/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress.z7;

import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.io.compress.BaseFileCompressor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

public class Z7Compressor
extends BaseFileCompressor {
    private SevenZOutputFile z7OutputFile;

    public Z7Compressor() {
        this("7z");
    }

    public Z7Compressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCompress() throws Exception {
        try {
            SevenZArchiveEntry entity;
            this.z7OutputFile = new SevenZOutputFile(new File(this.getAbsoluteCompressPath()));
            for (Map.Entry fileEntity : this.compressFiles.entrySet()) {
                entity = this.z7OutputFile.createArchiveEntry((File)fileEntity.getValue(), (String)fileEntity.getKey());
                this.z7OutputFile.putArchiveEntry((ArchiveEntry)entity);
                try (InputStream in = Files1.openInputStreamFast((File)fileEntity.getValue());){
                    Z7Compressor.transfer(in, this.z7OutputFile);
                }
                this.z7OutputFile.closeArchiveEntry();
                super.notify((String)fileEntity.getKey());
            }
            for (Map.Entry fileEntity : this.compressStreams.entrySet()) {
                entity = new SevenZArchiveEntry();
                entity.setName((String)fileEntity.getKey());
                entity.setSize((long)((InputStream)fileEntity.getValue()).available());
                this.z7OutputFile.putArchiveEntry((ArchiveEntry)entity);
                Z7Compressor.transfer((InputStream)fileEntity.getValue(), this.z7OutputFile);
                this.z7OutputFile.closeArchiveEntry();
                super.notify((String)fileEntity.getKey());
            }
            this.z7OutputFile.finish();
        }
        finally {
            Streams.close((AutoCloseable)this.z7OutputFile);
        }
    }

    protected static void transfer(InputStream input, SevenZOutputFile out) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while ((n = input.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
    }

    public SevenZOutputFile getCloseable() {
        return this.z7OutputFile;
    }
}

