/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.json;

import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Jsons {
    private Jsons() {
    }

    public static String toJson(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String toJsonWriteNull(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public static <T> T parse(String json, Class<T> clazz) {
        if (Strings.isBlank(json)) {
            return null;
        }
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (Strings.isBlank(json)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)json, clazz);
    }

    public static <T> Set<T> toSet(String json, Class<T> clazz) {
        if (Strings.isBlank(json)) {
            return new HashSet(16);
        }
        return (Set)JSON.parseObject((String)json, (TypeReference)new TypeReference<Set<T>>(new Type[]{clazz}){}, (Feature[])new Feature[0]);
    }

    public static Map<String, Object> toMap(String json) {
        if (Strings.isBlank(json)) {
            return new HashMap<String, Object>(16);
        }
        return JSON.parseObject((String)json);
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> kc, Class<V> vc) {
        if (Strings.isBlank(json)) {
            return new HashMap(16);
        }
        return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<K, V>>(new Type[]{kc, vc}){}, (Feature[])new Feature[0]);
    }

    public static Object readPath(String json, String path) {
        try {
            return JSONPath.read((String)json, (String)path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String readPathToString(String json, String path) {
        Object value = Jsons.readPath(json, path);
        if (value == null) {
            return null;
        }
        return Objects1.toString(value);
    }
}

