/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.define.collect.ConcurrentReferenceHashMap;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.reflect.TypeInfer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Constructors {
    private static final Map<Class<?>, Constructor<?>> CLASS_DEFAULT_CONSTRUCTOR_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    private Constructors() {
    }

    public static <T> Constructor<T> getDefaultConstructorByCache(Class<T> clazz) {
        Constructor<Object> constructor = CLASS_DEFAULT_CONSTRUCTOR_CACHE.get(clazz);
        if (constructor == null) {
            constructor = Constructors.getDefaultConstructor(clazz);
            CLASS_DEFAULT_CONSTRUCTOR_CACHE.put(clazz, constructor);
        }
        return constructor;
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        if (Arrays1.length(parameterTypes) == 0) {
            return Constructors.getDefaultConstructor(clazz);
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, int len) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        if (len == 0) {
            return Constructors.getDefaultConstructor(clazz);
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != len) continue;
                constructor.setAccessible(true);
                return constructor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T> List<Constructor<T>> getConstructors(Class<T> clazz, int len) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        ArrayList<Constructor<T>> list = new ArrayList<Constructor<T>>();
        if (len == 0) {
            list.add(Constructors.getDefaultConstructor(clazz));
            return list;
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != len) continue;
                constructor.setAccessible(true);
                list.add(constructor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static <T> List<Constructor<T>> getConstructors(Class<T> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        ArrayList<Constructor<T>> list = new ArrayList<Constructor<T>>();
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                constructor.setAccessible(true);
                list.add(constructor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static void setAccessible(Constructor<?> constructor) {
        Valid.notNull(constructor, "set accessible constructor class is null", new Object[0]);
        if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        Valid.notNull(constructor, "constructor is null", new Object[0]);
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.invoke("cannot initialize class", e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... values) {
        Valid.notNull(constructor, "constructor is null", new Object[0]);
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(values);
        }
        catch (Exception e) {
            throw Exceptions.invoke("cannot initialize class", e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("cannot initialize class: {}", clazz.getName()), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] parameterTypes, Object ... values) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(values);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("cannot initialize class: {}, parameterTypes: {}, values: {}", clazz.getName(), Arrays.toString(parameterTypes), Arrays.toString(values)), e);
        }
    }

    public static <T> T newInstanceInfer(Constructor<T> constructor, Object ... args) {
        Valid.notNull(constructor, "constructor is null", new Object[0]);
        if (Arrays1.isEmpty(args)) {
            return Constructors.newInstance(constructor);
        }
        return TypeInfer.newInstanceInfer(Lists.singleton(constructor), args);
    }

    public static <T> T newInstanceInfer(Class<T> clazz, Object ... args) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        if (Arrays1.isEmpty(args)) {
            return Constructors.newInstance(clazz);
        }
        List<Constructor<T>> constructors = Constructors.getConstructors(clazz, args.length);
        return TypeInfer.newInstanceInfer(constructors, args);
    }
}

