/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.regexp;

import cn.orionsec.kit.lang.utils.regexp.Patterns;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Matches {
    private Matches() {
    }

    public static int findNum(String s, String find) {
        int count = 0;
        Pattern p = Pattern.compile(find);
        Matcher m = p.matcher(s);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static boolean test(String s, String pattern) {
        return Patterns.getPattern(pattern).matcher(s).matches();
    }

    public static boolean test(String s, Pattern pattern) {
        return pattern.matcher(s).matches();
    }

    public static String extGroup(String s, String pattern) {
        Matcher matcher = Patterns.getPattern(pattern).matcher(s);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String extGroup(String s, Pattern pattern) {
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static List<String> extGroups(String s, String pattern) {
        ArrayList<String> groups = new ArrayList<String>();
        Matcher matcher = Patterns.getPattern(pattern).matcher(s);
        while (matcher.find()) {
            groups.add(matcher.group());
        }
        return groups;
    }

    public static List<String> extGroups(String s, Pattern pattern) {
        ArrayList<String> groups = new ArrayList<String>();
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            groups.add(matcher.group());
        }
        return groups;
    }

    public static boolean isSpaceLine(String str) {
        return Patterns.SPACE_LINE.matcher(str).matches();
    }

    public static boolean isSpacePoint(String str) {
        return Patterns.SPACE_POINT.matcher(str).matches();
    }

    public static boolean isDouble(String str) {
        return Patterns.DOUBLE.matcher(str).matches();
    }

    public static boolean isInteger(String str) {
        return Patterns.INTEGER.matcher(str).matches();
    }

    public static boolean isNumber(String str) {
        return Patterns.NUMBER.matcher(str).matches();
    }

    public static boolean isIpv4(String ip) {
        return Patterns.IPV4.matcher(ip).matches();
    }

    public static boolean isIpv6(String ip) {
        return Patterns.IPV6.matcher(ip).matches();
    }

    public static boolean isPhone(String phone) {
        return Patterns.PHONE.matcher(phone).matches();
    }

    public static boolean isEmail(String email) {
        return Patterns.EMAIL.matcher(email).matches();
    }

    public static boolean isHttp(String http) {
        return Patterns.HTTP.matcher(http).matches();
    }

    public static boolean isUri(String uri) {
        return Patterns.URI.matcher(uri).matches();
    }

    public static boolean isMd5(String s) {
        return Patterns.MD5.matcher(s).matches();
    }

    public static boolean isWindowsPath(String path) {
        return Patterns.WINDOWS_PATH.matcher(path).matches();
    }

    public static boolean isLinuxPath(String path) {
        return Patterns.LINUX_PATH.matcher(path).matches();
    }

    public static boolean isPath(String path) {
        return Matches.isWindowsPath(path) || Matches.isLinuxPath(path);
    }

    public static boolean isZipCode(String s) {
        return Patterns.ZIP_CODE.matcher(s).matches();
    }

    public static boolean isUtf(String s) {
        return Patterns.UTF.matcher(s).matches();
    }

    public static boolean isUuid(String s) {
        return Patterns.UUID.matcher(s).matches();
    }

    public static boolean isMac(String s) {
        return Patterns.MAC.matcher(s).matches();
    }

    public static boolean isHex(String s) {
        return Patterns.HEX.matcher(s).matches();
    }

    public static boolean isCreditCode(String s) {
        return Patterns.CREDIT_CODE.matcher(s).matches();
    }

    public static boolean isIdCard(String s) {
        return Patterns.ID_CARD.matcher(s).matches();
    }

    public static boolean isPlateNumber(String s) {
        return Patterns.PLATE_NUMBER.matcher(s).matches();
    }

    public static String extPhone(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.PHONE));
    }

    public static List<String> extPhoneList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.PHONE));
    }

    public static String extEmail(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.EMAIL));
    }

    public static List<String> extEmailList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.EMAIL));
    }

    public static String extHttp(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.HTTP));
    }

    public static List<String> extHttpList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.HTTP));
    }

    public static String extUri(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.URI));
    }

    public static List<String> extUriList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.URI));
    }

    public static String extInteger(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.INTEGER));
    }

    public static List<String> extIntegerList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.INTEGER));
    }

    public static String extDouble(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.DOUBLE));
    }

    public static List<String> extDoubleList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.DOUBLE));
    }

    public static String extNumber(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.NUMBER_EXT));
    }

    public static List<String> extNumberList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.NUMBER_EXT));
    }

    public static String extIpv4(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.IPV4));
    }

    public static List<String> extIpv4List(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.IPV4));
    }

    public static String extIpv6(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.IPV6));
    }

    public static List<String> extIpv6List(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.IPV6));
    }

    public static String extMac(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.MAC));
    }

    public static List<String> extMacList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.MAC));
    }

    public static String extCreditCode(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.CREDIT_CODE));
    }

    public static List<String> extCreditCodeList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.CREDIT_CODE));
    }

    public static String extIdCard(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.ID_CARD));
    }

    public static List<String> extIdCardList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.ID_CARD));
    }

    public static String extPlateNumber(String s) {
        return Matches.extGroup(s, Patterns.getPatternExt(Patterns.PLATE_NUMBER));
    }

    public static List<String> extPlateNumberList(String s) {
        return Matches.extGroups(s, Patterns.getPatternExt(Patterns.PLATE_NUMBER));
    }
}

