/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.time;

import cn.orionsec.kit.lang.utils.time.Dates;
import cn.orionsec.kit.lang.utils.time.Zodiacs;
import java.util.Calendar;
import java.util.Date;

public class LunarCalendar {
    private static final long BASE_DATE = -2206425943000L;
    private static final String[] MONTH = new String[]{"\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u814a"};
    private static final String[] DAY = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] GAN = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] ZHI = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final long[] LUNAR = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 92821L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42416L, 83315L, 21168L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46752L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 23232L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19195L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L, 84835L, 37744L, 18936L, 18800L, 25776L, 92326L, 59984L, 27424L, 108228L, 43744L, 37600L, 53987L, 51552L, 54615L, 54432L, 55888L, 23893L, 22176L, 42704L, 21972L, 21200L, 43448L, 43344L, 46240L, 46758L, 44368L, 21920L, 43940L, 42416L, 21168L, 45683L, 26928L, 29495L, 27296L, 44368L, 84821L, 19296L, 42352L, 21732L, 53600L, 59752L, 54560L, 55968L, 92838L, 22224L, 19168L, 43476L, 41680L, 53584L, 62034L};
    private final int year;
    private final int month;
    private final int day;
    private boolean leap;

    public LunarCalendar() {
        this(System.currentTimeMillis());
    }

    public LunarCalendar(Date date) {
        this(date.getTime());
    }

    public LunarCalendar(Calendar c) {
        this(c.getTime());
    }

    public LunarCalendar(long time) {
        int iMonth;
        int daysOfYear;
        int iYear;
        int offset = (int)((time - -2206425943000L) / 86400000L);
        int maxYear = iYear + LUNAR.length - 1;
        for (iYear = 1900; iYear <= maxYear && offset >= (daysOfYear = LunarCalendar.yearDays(iYear)); offset -= daysOfYear, ++iYear) {
        }
        this.year = iYear;
        int leapMonth = LunarCalendar.leapMonth(iYear);
        int daysOfMonth = 0;
        for (iMonth = 1; iMonth < 13 && offset > 0; ++iMonth) {
            if (leapMonth > 0 && iMonth == leapMonth + 1 && !this.leap) {
                --iMonth;
                this.leap = true;
                daysOfMonth = LunarCalendar.leapDays(this.year);
            } else {
                daysOfMonth = LunarCalendar.monthDays(this.year, iMonth);
            }
            offset -= daysOfMonth;
            if (!this.leap || iMonth != leapMonth + 1) continue;
            this.leap = false;
        }
        if (offset == 0 && leapMonth > 0 && iMonth == leapMonth + 1) {
            if (this.leap) {
                this.leap = false;
            } else {
                this.leap = true;
                --iMonth;
            }
        }
        if (offset < 0) {
            offset += daysOfMonth;
            --iMonth;
        }
        this.month = iMonth;
        this.day = offset + 1;
    }

    public LunarCalendar(int year, int month, int day) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.leap = Dates.isLeapYear(year);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String getChineseMonth() {
        return (this.leap ? "\u95f0" : "") + MONTH[this.month - 1] + "\u6708";
    }

    public String getChineseDay() {
        int n;
        String[] chineseTen = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
        int n2 = n = this.day % 10 == 0 ? 9 : this.day % 10 - 1;
        if (this.day > 30) {
            return "";
        }
        switch (this.day) {
            case 10: {
                return "\u521d\u5341";
            }
            case 20: {
                return "\u4e8c\u5341";
            }
            case 30: {
                return "\u4e09\u5341";
            }
        }
        return chineseTen[this.day / 10] + DAY[n];
    }

    public String getChineseZodiac() {
        return Zodiacs.getChineseZodiac(this.year);
    }

    public String getCyclical() {
        return LunarCalendar.cycle(this.year - 1900 + 36);
    }

    public String toChineseString() {
        return String.format("%s%s\u5e74 %s%s", this.getCyclical(), this.getChineseZodiac(), this.getChineseMonth(), this.getChineseDay());
    }

    public String toString() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    private static String cycle(int num) {
        return GAN[num % 10] + ZHI[num % 12];
    }

    private static int yearDays(int y) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((LUNAR[y - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + LunarCalendar.leapDays(y);
    }

    private static int leapDays(int y) {
        if (LunarCalendar.leapMonth(y) != 0) {
            return (LUNAR[y - 1900] & 0x10000L) != 0L ? 30 : 29;
        }
        return 0;
    }

    private static int monthDays(int y, int m) {
        return (LUNAR[y - 1900] & (long)(65536 >> m)) == 0L ? 29 : 30;
    }

    private static int leapMonth(int y) {
        return (int)(LUNAR[y - 1900] & 0xFL);
    }
}

