/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;

public class LocalCacheStore {
    private final File localDataStoreFile;
    private Map<Object, Object> localStore;
    public static final LocalCacheStore STORE = new LocalCacheStore();

    public LocalCacheStore() {
        this(new File(Files1.getPath(System.getProperty("user.dir") + "/data/dataStore.map")));
    }

    public LocalCacheStore(File file) {
        this.localDataStoreFile = file;
        this.init();
    }

    private void init() {
        Files1.touch(this.localDataStoreFile);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(Files.newInputStream(this.localDataStoreFile.toPath(), new OpenOption[0]));
            this.localStore = (Map)in.readObject();
        }
        catch (Exception e) {
            try {
                this.localStore = new HashMap<Object, Object>(8);
            }
            catch (Throwable throwable) {
                Streams.close(in);
                throw throwable;
            }
            Streams.close(in);
        }
        Streams.close(in);
    }

    public boolean deleteFile() {
        return this.localDataStoreFile.delete();
    }

    public void put(Serializable key, Serializable value) {
        this.localStore.put(key, value);
        this.write();
    }

    public void putAll(Map<? extends Serializable, ? extends Serializable> map) {
        this.localStore.putAll(map);
        this.write();
    }

    public Object get(Object key) {
        return this.localStore.get(key);
    }

    public Map<Object, Object> getMap() {
        return this.localStore;
    }

    public void remove(Object key) {
        this.localStore.remove(key);
        this.write();
    }

    public int size() {
        return this.localStore.size();
    }

    public void clear() {
        this.localStore.clear();
        this.write();
    }

    public void save() {
        this.write();
    }

    private void write() {
        if (this.localStore != null) {
            this.forceClean();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(Files.newOutputStream(this.localDataStoreFile.toPath(), new OpenOption[0]));
                out.writeObject(this.localStore);
                out.writeObject(null);
            }
            catch (Exception e) {
                try {
                    throw Exceptions.ioRuntime(e);
                }
                catch (Throwable throwable) {
                    Streams.close(out);
                    throw throwable;
                }
            }
            Streams.close(out);
        }
    }

    public void forceClean() {
        BufferedWriter clean = null;
        try {
            clean = new BufferedWriter(new FileWriter(this.localDataStoreFile));
            clean.write("");
            clean.flush();
        }
        catch (Exception e) {
            try {
                throw Exceptions.ioRuntime(e);
            }
            catch (Throwable throwable) {
                Streams.close(clean);
                throw throwable;
            }
        }
        Streams.close(clean);
    }

    public String toString() {
        return this.localStore.toString();
    }
}

