/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache;

import cn.orionsec.kit.lang.able.Buildable;
import cn.orionsec.kit.lang.define.cache.TimedCache;
import cn.orionsec.kit.lang.define.cache.TimedCacheChecker;
import cn.orionsec.kit.lang.define.cache.TimedCacheImpl;
import cn.orionsec.kit.lang.define.thread.ExecutorBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.function.BiConsumer;

public class TimedCacheBuilder<T>
implements Buildable<TimedCache<T>> {
    private static final ExecutorService CHECKER_EXECUTOR = ExecutorBuilder.create().namedThreadFactory("orion-cache-checker-").corePoolSize(1).maxPoolSize(Integer.MAX_VALUE).keepAliveTime(60000L).workQueue(new SynchronousQueue<Runnable>()).allowCoreThreadTimeout(true).build();
    private static final int DEFAULT_CHECK_INTERVAL = 5000;
    private int expireAfter;
    private int checkInterval = 5000;
    private Executor checkExecutor = CHECKER_EXECUTOR;
    private BiConsumer<String, T> expiredListener;

    private TimedCacheBuilder() {
    }

    public static <T> TimedCacheBuilder<T> create() {
        return new TimedCacheBuilder<T>();
    }

    public static <T> TimedCache<T> create(int expireAfter) {
        return new TimedCacheBuilder<T>().expireAfter(expireAfter).build();
    }

    public static <T> TimedCache<T> create(int expireAfter, int checkInterval) {
        return new TimedCacheBuilder<T>().expireAfter(expireAfter).checkInterval(checkInterval).build();
    }

    public TimedCacheBuilder<T> expireAfter(int expireAfter) {
        this.expireAfter = expireAfter;
        return this;
    }

    public TimedCacheBuilder<T> checkInterval(int checkInterval) {
        this.checkInterval = checkInterval;
        return this;
    }

    public TimedCacheBuilder<T> checkExecutor(Executor checkExecutor) {
        this.checkExecutor = checkExecutor;
        return this;
    }

    public TimedCacheBuilder<T> expiredListener(BiConsumer<String, T> expiredListener) {
        this.expiredListener = expiredListener;
        return this;
    }

    @Override
    public TimedCache<T> build() {
        ConcurrentHashMap store = new ConcurrentHashMap();
        TimedCacheChecker checker = new TimedCacheChecker(this.checkInterval, this.checkExecutor, store, this.expiredListener);
        return new TimedCacheImpl(this.expireAfter, store, checker);
    }
}

