/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache;

import cn.orionsec.kit.lang.define.cache.TimedCacheValue;
import cn.orionsec.kit.lang.utils.Threads;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class TimedCacheChecker<T>
implements Runnable,
Closeable {
    private final Map<String, TimedCacheValue<T>> store;
    private final Executor executor;
    private final int checkInterval;
    private final BiConsumer<String, T> expiredListener;
    private volatile boolean run = false;

    public TimedCacheChecker(int checkInterval, Executor executor, Map<String, TimedCacheValue<T>> store, BiConsumer<String, T> expiredListener) {
        this.store = store;
        this.executor = executor;
        this.checkInterval = checkInterval;
        this.expiredListener = expiredListener;
    }

    public void start() {
        this.run = true;
        this.executor.execute(this);
    }

    @Override
    public void run() {
        while (this.run) {
            Threads.sleep(this.checkInterval);
            long curr = System.currentTimeMillis();
            for (String key : this.store.keySet()) {
                TimedCacheValue<T> value = this.store.get(key);
                if (value.expireTime >= curr) continue;
                this.store.remove(key);
                this.expiredListener.accept(key, (String)value.value);
            }
        }
    }

    @Override
    public void close() {
        this.run = false;
    }
}

