/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.constant.Const;
import cn.orionsec.kit.lang.utils.Assert;
import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FixedQueue<E>
extends ConcurrentLinkedQueue<E>
implements Serializable {
    private static final long serialVersionUID = -12908043940801293L;
    private final int maxSize;

    public FixedQueue(int maxSize) {
        this.maxSize = Assert.gt(maxSize, Const.N_0);
    }

    public static <E> FixedQueue<E> create(int maxSize) {
        return new FixedQueue<E>(maxSize);
    }

    @Override
    public boolean offer(E s) {
        if (this.isFull()) {
            this.poll();
        }
        return super.offer(s);
    }

    public boolean isFull() {
        return this.size() >= this.maxSize;
    }
}

