/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.define.collect.MultiMap;
import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeMap;

public class MultiTreeMap<K, V, E>
extends TreeMap<K, TreeMap<V, E>>
implements MultiMap<K, V, E, TreeMap<V, E>>,
Serializable {
    private static final long serialVersionUID = -786438489922021L;
    private Comparator<? super V> valueComparator;

    public MultiTreeMap() {
    }

    public MultiTreeMap(Comparator<? super K> comparator) {
        super(comparator);
    }

    public MultiTreeMap(Comparator<? super K> comparator, Comparator<? super V> valueComparator) {
        super(comparator);
        this.valueComparator = valueComparator;
    }

    public static <K, V, E> MultiTreeMap<K, V, E> create() {
        return new MultiTreeMap<K, V, E>();
    }

    public static <K, V, E> MultiTreeMap<K, V, E> create(Comparator<? super K> comparator) {
        return new MultiTreeMap<K, V, E>(comparator);
    }

    public static <K, V, E> MultiTreeMap<K, V, E> create(Comparator<? super K> comparator, Comparator<? super V> keyComparator) {
        return new MultiTreeMap<K, V, E>(comparator, keyComparator);
    }

    public void valueComparator(Comparator<? super V> valueComparator) {
        this.valueComparator = valueComparator;
    }

    @Override
    public TreeMap<V, E> computeSpace(K e) {
        return super.computeIfAbsent(e, k -> new TreeMap(this.valueComparator));
    }
}

