/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.function.ByteSupplier;
import cn.orionsec.kit.lang.function.CharSupplier;
import cn.orionsec.kit.lang.function.FloatSupplier;
import cn.orionsec.kit.lang.function.ShortSupplier;
import cn.orionsec.kit.lang.function.Suppliers;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.convert.Converts;
import cn.orionsec.kit.lang.utils.math.BigDecimals;
import cn.orionsec.kit.lang.utils.math.BigIntegers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public interface MutableCollection<E>
extends Collection<E> {
    public E get(int var1);

    default public Byte getByte(int i) {
        return this.getByte(i, Suppliers.nullSupplier());
    }

    default public Byte getByte(int i, Byte def) {
        return this.getByte(i, () -> def);
    }

    default public Byte getByte(int i, Supplier<Byte> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toByte(e);
    }

    default public byte getByteValue(int i) {
        return this.getByteValue(i, Suppliers.BYTE_SUPPLIER);
    }

    default public byte getByteValue(int i, byte def) {
        return this.getByteValue(i, () -> def);
    }

    default public byte getByteValue(int i, ByteSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsByte();
        }
        return Converts.toByte(e);
    }

    default public Short getShort(int i) {
        return this.getShort(i, Suppliers.nullSupplier());
    }

    default public Short getShort(int i, Short def) {
        return this.getShort(i, () -> def);
    }

    default public Short getShort(int i, Supplier<Short> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toShort(e);
    }

    default public short getShortValue(int i) {
        return this.getShortValue(i, Suppliers.SHORT_SUPPLIER);
    }

    default public short getShortValue(int i, short def) {
        return this.getShortValue(i, () -> def);
    }

    default public short getShortValue(int i, ShortSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsShort();
        }
        return Converts.toShort(e);
    }

    default public Integer getInteger(int i) {
        return this.getInteger(i, Suppliers.nullSupplier());
    }

    default public Integer getInteger(int i, Integer def) {
        return this.getInteger(i, () -> def);
    }

    default public Integer getInteger(int i, Supplier<Integer> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toInt(e);
    }

    default public int getIntValue(int i) {
        return this.getIntValue(i, Suppliers.INT_SUPPLIER);
    }

    default public int getIntValue(int i, int def) {
        return this.getIntValue(i, () -> def);
    }

    default public int getIntValue(int i, IntSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsInt();
        }
        return Converts.toInt(e);
    }

    default public Long getLong(int i) {
        return this.getLong(i, Suppliers.nullSupplier());
    }

    default public Long getLong(int i, Long def) {
        return this.getLong(i, () -> def);
    }

    default public Long getLong(int i, Supplier<Long> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toLong(e);
    }

    default public long getLongValue(int i) {
        return this.getLongValue(i, Suppliers.LONG_SUPPLIER);
    }

    default public long getLongValue(int i, long def) {
        return this.getLongValue(i, () -> def);
    }

    default public long getLongValue(int i, LongSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsLong();
        }
        return Converts.toLong(e);
    }

    default public Float getFloat(int i) {
        return this.getFloat(i, Suppliers.nullSupplier());
    }

    default public Float getFloat(int i, Float def) {
        return this.getFloat(i, () -> def);
    }

    default public Float getFloat(int i, Supplier<Float> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Float.valueOf(Converts.toFloat(e));
    }

    default public float getFloatValue(int i) {
        return this.getFloatValue(i, Suppliers.FLOAT_SUPPLIER);
    }

    default public float getFloatValue(int i, float def) {
        return this.getFloatValue(i, () -> def);
    }

    default public float getFloatValue(int i, FloatSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsFloat();
        }
        return Converts.toFloat(e);
    }

    default public Double getDouble(int i) {
        return this.getDouble(i, Suppliers.nullSupplier());
    }

    default public Double getDouble(int i, Double def) {
        return this.getDouble(i, () -> def);
    }

    default public Double getDouble(int i, Supplier<Double> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toDouble(e);
    }

    default public double getDoubleValue(int i) {
        return this.getDoubleValue(i, Suppliers.DOUBLE_SUPPLIER);
    }

    default public double getDoubleValue(int i, double def) {
        return this.getDoubleValue(i, () -> def);
    }

    default public double getDoubleValue(int i, DoubleSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsDouble();
        }
        return Converts.toDouble(e);
    }

    default public Boolean getBoolean(int i) {
        return this.getBoolean(i, Suppliers.nullSupplier());
    }

    default public Boolean getBoolean(int i, Boolean def) {
        return this.getBoolean(i, () -> def);
    }

    default public Boolean getBoolean(int i, Supplier<Boolean> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toBoolean(e);
    }

    default public boolean getBooleanValue(int i) {
        return this.getBooleanValue(i, Suppliers.BOOLEAN_SUPPLIER);
    }

    default public boolean getBooleanValue(int i, boolean def) {
        return this.getBooleanValue(i, () -> def);
    }

    default public boolean getBooleanValue(int i, BooleanSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsBoolean();
        }
        return Converts.toBoolean(e);
    }

    default public Character getCharacter(int i) {
        return this.getCharacter(i, Suppliers.nullSupplier());
    }

    default public Character getCharacter(int i, Character def) {
        return this.getCharacter(i, () -> def);
    }

    default public Character getCharacter(int i, Supplier<Character> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Character.valueOf(Converts.toChar(e));
    }

    default public char getCharValue(int i) {
        return this.getCharValue(i, Suppliers.CHAR_SUPPLIER);
    }

    default public char getCharValue(int i, char def) {
        return this.getCharValue(i, () -> def);
    }

    default public char getCharValue(int i, CharSupplier supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.getAsChar();
        }
        return Converts.toChar(e);
    }

    default public String getString(int i) {
        return this.getString(i, Suppliers.nullSupplier());
    }

    default public String getString(int i, String def) {
        return this.getString(i, () -> def);
    }

    default public String getString(int i, Supplier<String> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toString(e);
    }

    default public Date getDate(int i) {
        return this.getDate(i, Suppliers.nullSupplier());
    }

    default public Date getDate(int i, Date def) {
        return this.getDate(i, () -> def);
    }

    default public Date getDate(int i, Supplier<Date> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toDate(e);
    }

    default public LocalDateTime getLocalDateTime(int i) {
        return this.getLocalDateTime(i, Suppliers.nullSupplier());
    }

    default public LocalDateTime getLocalDateTime(int i, LocalDateTime def) {
        return this.getLocalDateTime(i, () -> def);
    }

    default public LocalDateTime getLocalDateTime(int i, Supplier<LocalDateTime> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toLocalDateTime(e);
    }

    default public LocalDate getLocalDate(int i) {
        return this.getLocalDate(i, Suppliers.nullSupplier());
    }

    default public LocalDate getLocalDate(int i, LocalDate def) {
        return this.getLocalDate(i, () -> def);
    }

    default public LocalDate getLocalDate(int i, Supplier<LocalDate> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return Converts.toLocalDate(e);
    }

    default public BigDecimal getBigDecimal(int i) {
        return this.getBigDecimal(i, Suppliers.nullSupplier());
    }

    default public BigDecimal getBigDecimal(int i, BigDecimal def) {
        return this.getBigDecimal(i, () -> def);
    }

    default public BigDecimal getBigDecimal(int i, Supplier<BigDecimal> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return BigDecimals.toBigDecimal(e);
    }

    default public BigInteger getBigInteger(int i) {
        return this.getBigInteger(i, Suppliers.nullSupplier());
    }

    default public BigInteger getBigInteger(int i, BigInteger def) {
        return this.getBigInteger(i, () -> def);
    }

    default public BigInteger getBigInteger(int i, Supplier<BigInteger> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return BigIntegers.toBigInteger(e);
    }

    default public <V> V getObject(int i) {
        return (V)this.getObject(i, Suppliers.nullSupplier());
    }

    default public <V> V getObject(int i, V def) {
        return (V)this.getObject(i, () -> def);
    }

    default public <V> V getObject(int i, Supplier<V> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return (V)e;
    }

    default public E get(int i, E def) {
        return (E)this.get(i, () -> def);
    }

    default public E get(int i, Supplier<E> supplier) {
        Assert.notNull(supplier);
        E e = this.get(i);
        if (e == null) {
            return supplier.get();
        }
        return e;
    }
}

