/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.utils.Assert;
import java.util.AbstractList;
import java.util.List;

public class PartitionList<E>
extends AbstractList<List<E>> {
    private final List<E> list;
    private final int size;

    public PartitionList(List<E> list, int size) {
        this.list = list;
        this.size = size;
    }

    public static <E> PartitionList<E> create(List<E> list, int size) {
        return new PartitionList<E>(list, size);
    }

    @Override
    public List<E> get(int index) {
        int listSize = this.size();
        Assert.gte(index, 0, "index {} must not be negative", index);
        Assert.lt(index, listSize, "index {} must be less than size {}", index, listSize);
        int start = index * this.size;
        int end = Math.min(start + this.size, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return (this.list.size() + this.size - 1) / this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

