/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.math.Numbers;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PartitionSet<E>
extends AbstractSet<Set<E>>
implements Iterator<Set<E>> {
    private final Iterator<E> iterator;
    private final int size;
    private final int totalSize;
    private int current;

    public PartitionSet(Set<E> set, int size) {
        this.iterator = set.iterator();
        this.size = size;
        this.totalSize = set.size();
    }

    public static <E> PartitionSet<E> create(Set<E> set, int size) {
        return new PartitionSet<E>(set, size);
    }

    @Override
    public int size() {
        return (this.totalSize + this.size - 1) / this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public Iterator<Set<E>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.size() > this.current;
    }

    @Override
    public Set<E> next() {
        if (!this.hasNext()) {
            throw Exceptions.noSuchElement("there are no more elements");
        }
        ++this.current;
        HashSet<E> set = new HashSet<E>(Numbers.getMin2Power(this.size));
        for (int i = 0; i < this.size && this.iterator.hasNext(); ++i) {
            set.add(this.iterator.next());
        }
        return set;
    }
}

