/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.define.iterator.SingletonIterator;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class SingletonList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -945902293805399L;
    private final E element;

    public SingletonList(E o) {
        this.element = o;
    }

    public static <E> SingletonList<E> create(E o) {
        return new SingletonList<E>(o);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object obj) {
        return Objects1.eq(obj, this.element);
    }

    @Override
    public E get(int index) {
        if (index != 0) {
            throw Exceptions.index("index: " + index + ", size: 1");
        }
        return this.element;
    }

    @Override
    public Iterator<E> iterator() {
        return new SingletonIterator<E>(this.element);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        action.accept(this.element);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw Exceptions.unsupported();
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        throw Exceptions.unsupported();
    }

    @Override
    public void sort(Comparator<? super E> c) {
    }
}

