/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.iterator;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;

public class ByteArrayIterator
implements Iterator<Integer>,
Iterable<Integer>,
SafeCloseable,
Serializable {
    private final InputStream in;
    private final byte[] buffer;
    private int read;
    private boolean isRead;
    private boolean autoClose;

    public ByteArrayIterator(InputStream in, byte[] buffer) {
        Assert.notNull(in, "input stream is null", new Object[0]);
        Assert.notNull(buffer, "buffer is null", new Object[0]);
        this.in = in;
        this.buffer = buffer;
    }

    public ByteArrayIterator autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public ByteArrayIterator skip(long skip) {
        try {
            this.in.skip(skip);
            return this;
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.read == -1) {
            return false;
        }
        if (this.isRead) {
            return true;
        }
        try {
            this.read = this.in.read(this.buffer);
            this.isRead = true;
            return this.read != -1;
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw Exceptions.noSuchElement("no more data");
        }
        this.isRead = false;
        return this.read;
    }

    @Override
    public void close() {
        this.read = -1;
        this.isRead = false;
        if (this.autoClose) {
            Streams.close(this.in);
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return this;
    }
}

