/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.iterator;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Iterator;

public class LineIterator
implements Iterator<String>,
Iterable<String>,
SafeCloseable,
Serializable {
    private static final long serialVersionUID = 129389409684095L;
    private final BufferedReader reader;
    private String current;
    private boolean finished;
    private boolean autoClose;

    public LineIterator(Reader reader) {
        this(reader, 8192);
    }

    public LineIterator(Reader reader, int bufferSize) {
        Assert.notNull(reader, "reader is null", new Object[0]);
        this.reader = Streams.toBufferedReader(reader, bufferSize);
    }

    public LineIterator autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public LineIterator skip(long skip) {
        try {
            this.reader.skip(skip);
            return this;
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public LineIterator skipLine(int skipLine) {
        try {
            for (int i = 0; i < skipLine && this.reader.readLine() != null; ++i) {
            }
            return this;
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.current != null) {
            return true;
        }
        try {
            this.current = this.reader.readLine();
            if (this.current == null) {
                this.finished = true;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw Exceptions.noSuchElement("no more lines");
        }
        String tmp = this.current;
        this.current = null;
        return tmp;
    }

    @Override
    public void close() {
        this.finished = true;
        this.current = null;
        if (this.autoClose) {
            Streams.close(this.reader);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

