/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.wrapper;

import cn.orionsec.kit.lang.KitLangConfiguration;
import cn.orionsec.kit.lang.able.ILogObject;
import cn.orionsec.kit.lang.able.IMapObject;
import cn.orionsec.kit.lang.config.KitConfig;
import cn.orionsec.kit.lang.define.support.CloneSupport;
import cn.orionsec.kit.lang.define.wrapper.CodeInfo;
import cn.orionsec.kit.lang.define.wrapper.HttpWrapper;
import cn.orionsec.kit.lang.define.wrapper.Wrapper;
import cn.orionsec.kit.lang.id.UUIds;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.json.Jsons;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class RpcWrapper<T>
extends CloneSupport<RpcWrapper<T>>
implements Wrapper<T>,
ILogObject,
IMapObject<String, Object> {
    private static final long serialVersionUID = 7940497300629314L;
    public static final Integer RPC_SUCCESS_CODE = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.RPC_SUCCESS_CODE);
    public static final String RPC_SUCCESS_MESSAGE = (String)KitConfig.get(KitLangConfiguration.CONFIG.RPC_SUCCESS_MESSAGE);
    public static final Integer RPC_ERROR_CODE = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.RPC_ERROR_CODE);
    public static final String RPC_ERROR_MESSAGE = (String)KitConfig.get(KitLangConfiguration.CONFIG.RPC_ERROR_MESSAGE);
    public static final String PRC_TRACE_PREFIX = (String)KitConfig.get(KitLangConfiguration.CONFIG.PRC_TRACE_PREFIX);
    @JSONField(ordinal=0)
    private int code;
    @JSONField(ordinal=1)
    private String msg;
    @JSONField(ordinal=4)
    private T data;
    @JSONField(ordinal=3)
    private List<String> errorMessages;
    @JSONField(ordinal=2)
    private String traceId;

    public RpcWrapper() {
        this(RPC_SUCCESS_CODE, RPC_SUCCESS_MESSAGE, null);
    }

    public RpcWrapper(int code) {
        this(code, RPC_SUCCESS_MESSAGE, null);
    }

    public RpcWrapper(int code, String msg) {
        this(code, msg, null);
    }

    public RpcWrapper(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.traceId = this.createTrace();
    }

    public RpcWrapper(CodeInfo info) {
        this(info.code(), info.message(), null);
    }

    public RpcWrapper(CodeInfo info, T data) {
        this(info.code(), info.message(), data);
    }

    public static <T> RpcWrapper<T> get() {
        return new RpcWrapper<T>();
    }

    public static <T> RpcWrapper<T> of(CodeInfo info) {
        return new RpcWrapper<T>(info.code(), info.message());
    }

    public static <T> RpcWrapper<T> of(CodeInfo info, T data) {
        return new RpcWrapper<T>(info.code(), info.message(), data);
    }

    public static <T> RpcWrapper<T> of(int code) {
        return new RpcWrapper<T>(code);
    }

    public static <T> RpcWrapper<T> of(int code, String msg) {
        return new RpcWrapper<T>(code, msg);
    }

    public static <T> RpcWrapper<T> of(int code, String msg, T data) {
        return new RpcWrapper<T>(code, msg, data);
    }

    public static <T> RpcWrapper<T> success() {
        return new RpcWrapper<T>(RPC_SUCCESS_CODE, RPC_SUCCESS_MESSAGE);
    }

    public static <T> RpcWrapper<T> success(T data) {
        return new RpcWrapper<T>(RPC_SUCCESS_CODE, RPC_SUCCESS_MESSAGE, data);
    }

    public static <T> RpcWrapper<T> error() {
        return new RpcWrapper<T>(RPC_ERROR_CODE, RPC_ERROR_MESSAGE);
    }

    public static <T> RpcWrapper<T> error(String msg) {
        return new RpcWrapper<T>(RPC_ERROR_CODE, msg);
    }

    public static <T> RpcWrapper<T> error(String msg, Object ... params) {
        return new RpcWrapper<T>(RPC_ERROR_CODE, Strings.format(msg, params));
    }

    public static <T> RpcWrapper<T> error(Throwable t) {
        if (t == null) {
            return new RpcWrapper<T>(RPC_ERROR_CODE, RPC_ERROR_MESSAGE);
        }
        return new RpcWrapper<T>(RPC_ERROR_CODE, t.getMessage());
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isSuccess() {
        return !RPC_ERROR_CODE.equals(this.code) && Lists.isEmpty(this.errorMessages);
    }

    public void checkIsError() {
        if (!this.isSuccess()) {
            throw Exceptions.rpcWrapper(this);
        }
    }

    public void checkIsError(Supplier<? extends RuntimeException> e) {
        if (!this.isSuccess()) {
            throw e.get();
        }
    }

    public RpcWrapper<T> addErrorMessage(String errorMsg) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(errorMsg);
        return this;
    }

    public RpcWrapper<T> code(int code) {
        this.code = code;
        return this;
    }

    public RpcWrapper<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public RpcWrapper<T> data(T data) {
        this.data = data;
        return this;
    }

    public RpcWrapper<T> trace(Object object) {
        this.traceId = PRC_TRACE_PREFIX + object;
        return this;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTraceId(String traceId) {
        this.traceId = PRC_TRACE_PREFIX + traceId;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages == null ? (this.errorMessages = new ArrayList<String>()) : this.errorMessages;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getErrorMessageString() {
        return this.errorMessages == null ? "" : Lists.join(this.errorMessages, ",");
    }

    private String createTrace() {
        this.traceId = PRC_TRACE_PREFIX + UUIds.random32();
        return this.traceId;
    }

    public String toString() {
        return this.toJsonString();
    }

    @Override
    public String toLogString() {
        boolean success = this.isSuccess();
        StringBuilder builder = new StringBuilder("RpcWrapper: ").append("\n  isSuccess ==> ").append(success).append("\n    traceId ==> ").append(this.traceId).append("\n       code ==> ").append(this.code).append("\n        msg ==> ").append(this.msg).append("\n       data ==> ").append(Jsons.toJsonWriteNull(this.data));
        if (!success) {
            builder.append("\n   errorMsg ==> ").append(this.errorMessages);
        }
        return builder.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("code", this.code);
        map.put("msg", this.msg);
        map.put("data", this.data);
        map.put("traceId", this.traceId);
        map.put("errorMessages", this.errorMessages);
        return map;
    }

    public HttpWrapper<T> toHttpWrapper() {
        return HttpWrapper.of(this.code, this.msg, this.data);
    }

    public <E> RpcWrapper<E> map(Function<T, E> mapping) {
        RpcWrapper<T> result = new RpcWrapper<T>();
        result.code = this.code;
        result.msg = this.msg;
        result.traceId = this.traceId;
        result.errorMessages = this.errorMessages;
        result.data = Objects1.map(this.data, mapping);
        return result;
    }

    public Optional<T> optional() {
        return Optional.of(this).filter(RpcWrapper::isSuccess).map(RpcWrapper::getData);
    }
}

