/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.wrapper;

import cn.orionsec.kit.lang.able.IJsonObject;
import cn.orionsec.kit.lang.define.iterator.ArrayIterator;
import cn.orionsec.kit.lang.define.iterator.EmptyIterator;
import cn.orionsec.kit.lang.define.support.CloneSupport;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.json.Jsons;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class Tuple
extends CloneSupport<Tuple>
implements Serializable,
IJsonObject,
Iterable<Object> {
    private static final long serialVersionUID = 228374192841290087L;
    private final Object[] members;

    public Tuple(Object ... members) {
        Assert.notEmpty(members, "arguments size is zero", new Object[0]);
        this.members = members;
    }

    public static Tuple of(Object ... members) {
        return new Tuple(members);
    }

    public <T> T get(int index) {
        return (T)this.members[index];
    }

    public Object[] getMembers() {
        return this.members;
    }

    public int size() {
        return this.members.length;
    }

    public int hashCode() {
        return 31 * Arrays.deepHashCode(this.members);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Arrays.deepEquals(this.members, other.members);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return Arrays1.isEmpty(this.members);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isNotEmpty() {
        return Arrays1.isNotEmpty(this.members);
    }

    public Stream<?> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.members);
    }

    public <T> Optional<T> optional(int index) {
        int size = this.size();
        if (size > index) {
            return Optional.ofNullable(this.members[index]);
        }
        return Optional.empty();
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.isEmpty()) {
            return new ArrayIterator<Object>(this.members).iterator();
        }
        return new EmptyIterator<Object>();
    }

    @Override
    public Spliterator<Object> spliterator() {
        return new ArrayIterator<Object>(this.members).spliterator();
    }

    @Override
    public void forEach(Consumer<? super Object> action) {
        if (!this.isEmpty()) {
            new ArrayIterator<Object>(this.members).forEach(action);
        }
    }

    public String toString() {
        return Arrays.toString(this.members);
    }

    @Override
    public String toJsonString() {
        return Jsons.toJsonWriteNull(this.members);
    }
}

