/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.exception;

import javax.script.ScriptException;

public class ScriptExecuteException
extends RuntimeException {
    private static final long serialVersionUID = 8247610319171014183L;
    private String fileName;
    private int lineNumber = -1;
    private int columnNumber = -1;

    public ScriptExecuteException() {
    }

    public ScriptExecuteException(String message) {
        super(message);
    }

    public ScriptExecuteException(String message, Throwable cause) {
        super(message, cause);
    }

    public ScriptExecuteException(Throwable cause) {
        super(cause);
    }

    public ScriptExecuteException(ScriptException e) {
        super(e);
        this.fileName = e.getFileName();
        this.lineNumber = e.getLineNumber();
        this.columnNumber = e.getColumnNumber();
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (this.fileName != null) {
            msg = msg + " in " + this.fileName;
            if (this.lineNumber != -1) {
                msg = msg + " at line number " + this.lineNumber;
            }
            if (this.columnNumber != -1) {
                msg = msg + " at column number " + this.columnNumber;
            }
        }
        return msg;
    }
}

