/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.function.impl;

import cn.orionsec.kit.lang.define.Console;
import cn.orionsec.kit.lang.function.Functions;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;

public class ReaderLineConsumer
implements Consumer<InputStream> {
    private String charset = "UTF-8";
    private int bufferSize = 8192;
    private Consumer<String> lineConsumer;

    public ReaderLineConsumer() {
        this(Functions.emptyConsumer());
    }

    public ReaderLineConsumer(Consumer<String> lineConsumer) {
        this.lineConsumer = lineConsumer;
    }

    public ReaderLineConsumer charset(String charset) {
        this.charset = charset;
        return this;
    }

    public ReaderLineConsumer bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public ReaderLineConsumer lineConsumer(Consumer<String> lineConsumer) {
        Assert.notNull(lineConsumer, "line consumer is null", new Object[0]);
        this.lineConsumer = lineConsumer;
        return this;
    }

    public ReaderLineConsumer lineConsumer(Consumer<String> lineConsumer, String charset) {
        Assert.notNull(lineConsumer, "line consumer is null", new Object[0]);
        this.lineConsumer = lineConsumer;
        this.charset = charset;
        return this;
    }

    public static ReaderLineConsumer printer() {
        return ReaderLineConsumer.printer("UTF-8");
    }

    public static ReaderLineConsumer printer(String charset) {
        return new ReaderLineConsumer(xva$0 -> Console.trace(xva$0)).charset(charset);
    }

    @Override
    public void accept(InputStream input) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, this.charset), this.bufferSize);
            while ((line = reader.readLine()) != null) {
                this.lineConsumer.accept(line);
            }
        }
        catch (IOException e) {
            if (!"Stream closed".equals(e.getMessage())) {
                throw Exceptions.ioRuntime(e);
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }
}

