/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Assert;
import java.util.Comparator;

public class Compares {
    private Compares() {
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2) {
        return o1.compareTo(o2);
    }

    public static <T> int compare(T o1, T o2, Comparator<T> c) {
        return c.compare(o1, o2);
    }

    public static <T extends Comparable<T>> boolean compared(T o1, T o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.compareTo(o2) == 0;
    }

    public static <T> boolean compared(T o1, T o2, Comparator<T> c) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return c.compare(o1, o2) == 0;
    }

    public static <T extends Comparable<T>> boolean lt(T value, T refer) {
        Assert.notNull(value, "value is null", new Object[0]);
        Assert.notNull(refer, "refer is null", new Object[0]);
        return value.compareTo(refer) < 0;
    }

    public static <T extends Comparable<T>> boolean lte(T value, T refer) {
        Assert.notNull(value, "value is null", new Object[0]);
        Assert.notNull(refer, "refer is null", new Object[0]);
        return value.compareTo(refer) <= 0;
    }

    public static <T extends Comparable<T>> boolean gt(T value, T refer) {
        Assert.notNull(value, "value is null", new Object[0]);
        Assert.notNull(refer, "refer is null", new Object[0]);
        return value.compareTo(refer) > 0;
    }

    public static <T extends Comparable<T>> boolean gte(T value, T refer) {
        Assert.notNull(value, "value is null", new Object[0]);
        Assert.notNull(refer, "refer is null", new Object[0]);
        return value.compareTo(refer) >= 0;
    }

    public static <T extends Comparable<T>> boolean inRange(T value, T start, T end) {
        Assert.notNull(value, "value is null", new Object[0]);
        Assert.notNull(start, "start range is null", new Object[0]);
        Assert.notNull(value, "end range is null", new Object[0]);
        return start.compareTo(value) <= 0 && value.compareTo(end) <= 0;
    }

    public static <T extends Comparable<T>> boolean notInRange(T value, T start, T end) {
        return !Compares.inRange(value, start, end);
    }

    public static <T extends Comparable<T>> boolean rangeInRange(T rangeStart, T rangeEnd, T testRangeStart, T testRangeEnd) {
        Assert.notNull(rangeStart, "start range is null", new Object[0]);
        Assert.notNull(rangeEnd, "end range is null", new Object[0]);
        Assert.notNull(testRangeStart, "test start range is null", new Object[0]);
        Assert.notNull(testRangeEnd, "test end range is null", new Object[0]);
        return rangeStart.compareTo(testRangeStart) <= 0 && rangeStart.compareTo(testRangeEnd) <= 0 && testRangeStart.compareTo(rangeEnd) <= 0 && testRangeEnd.compareTo(rangeEnd) <= 0;
    }

    public static <T extends Comparable<T>> boolean rangeNotInRange(T rangeStart, T rangeEnd, T testRangeStart, T testRangeEnd) {
        return !Compares.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static <T extends Comparable<T>> boolean cross(T start1, T end1, T start2, T end2) {
        Assert.notNull(start1, "start range1 is null", new Object[0]);
        Assert.notNull(end1, "end range1 is null", new Object[0]);
        Assert.notNull(start2, "start range2 is null", new Object[0]);
        Assert.notNull(end2, "end range2 is null", new Object[0]);
        if (end1.compareTo(start2) <= 0 || end2.compareTo(start1) <= 0) {
            return false;
        }
        return start1 == start2 && end1 == end2 || Compares.rangeInRange(start1, end1, start2, end2) || Compares.inRange(start2, start1, end1) || Compares.rangeInRange(start2, end2, start1, end1) || Compares.inRange(start1, start2, end2);
    }

    public static <T extends Comparable<T>> boolean uncross(T start1, T end1, T start2, T end2) {
        return !Compares.cross(start1, end1, start2, end2);
    }
}

