/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Strings;

public class Desensitizes {
    public static final String REPLACER = "*";
    public static final char REPLACER_CHAR = '*';

    private Desensitizes() {
    }

    public static String mixFirstName(String s) {
        return Desensitizes.mix(s, 0, s.length() - 1, '*');
    }

    public static String mixName(String s) {
        return Desensitizes.mix(s, 1, 0, '*');
    }

    public static String mixPhone(String s) {
        return Desensitizes.mix(s, 3, 4, "****");
    }

    public static String mixCardNum(String s) {
        return Desensitizes.mix(s, 2, 2, "**************");
    }

    public static String mix(String s, int keepStart, int keepEnd) {
        return Desensitizes.mix(s, keepStart, keepEnd, '*');
    }

    public static String mix(String s, int keepStart, int keepEnd, char replacer) {
        int length = Strings.length(s);
        if (length == 0) {
            return "";
        }
        return Desensitizes.mix(s, keepStart, keepEnd, Strings.repeat(replacer, length - keepStart - keepEnd), 1);
    }

    public static String mix(String s, int keepStart, int keepEnd, String replacer) {
        return Desensitizes.mix(s, keepStart, keepEnd, replacer, 1);
    }

    public static String mix(String s, int keepStart, int keepEnd, String replacer, int repeat) {
        int length = Strings.length(s);
        if (length == 0) {
            return "";
        }
        if (keepStart < 0) {
            keepStart = 0;
        }
        if (keepEnd < 0) {
            keepEnd = 0;
        }
        if (keepStart + keepEnd >= length) {
            return s;
        }
        char[] chars = s.toCharArray();
        char[] replacerArr = Strings.repeat(replacer, repeat).toCharArray();
        char[] res = new char[keepStart + keepEnd + replacerArr.length];
        System.arraycopy(chars, 0, res, 0, keepStart);
        System.arraycopy(replacerArr, 0, res, keepStart, replacerArr.length);
        System.arraycopy(chars, chars.length - keepEnd, res, keepStart + replacerArr.length, keepEnd);
        return new String(res);
    }
}

