/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.math.Numbers;
import cn.orionsec.kit.lang.utils.random.Randoms;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Systems {
    public static final String LINE_SEPARATOR = Systems.getProperty("line.separator", "\n");
    public static final String FILE_SEPARATOR = File.separator;
    public static final boolean BE_UNIX = "/".equals(File.separator);
    public static final boolean BE_WINDOWS = "\\".equals(File.separator);
    public static final boolean BE_ANDROID;
    public static final String USER_NAME;
    public static final String FILE_ENCODING;
    public static final String HOME_DIR;
    public static final String USER_DIR;
    public static final String TEMP_DIR;
    public static final String OS_NAME;
    public static final String OS_VERSION;
    public static final String HOST_NAME;
    public static final int PID;
    public static final String JAVA_SPEC_VERSION;
    public static final String JAVA_HOME;
    public static final int PROCESS_NUM;
    public static final int SEED;

    private Systems() {
    }

    public static int getMachineCode(int startRange, int endRange) {
        return Numbers.getRangeNum(Systems.getMachineCode(), startRange, endRange);
    }

    public static int getMachineCode() {
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
            }
            return sb.toString().hashCode() << 16;
        }
        catch (Throwable e) {
            return Randoms.randomInt() << 16;
        }
    }

    public static int getProcessCode(int startRange, int endRange) {
        return Numbers.getRangeNum(Systems.getProcessCode(), startRange, endRange);
    }

    public static int getProcessCode() {
        int loaderId = System.identityHashCode(Systems.class.getClassLoader());
        String processLoaderId = Integer.toHexString(PID) + Integer.toHexString(loaderId);
        return processLoaderId.hashCode() & 0xFFFF;
    }

    public static List<String> getJvmInputArgs() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public static void exit(int code) {
        System.exit(code);
    }

    public static void halt(int status) {
        Runtime.getRuntime().halt(status);
    }

    public static void addShutdownHook(Thread thread) {
        Runtime.getRuntime().addShutdownHook(thread);
    }

    public static void addShutdownHook(Runnable runnable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }

    public static void removeShutdownHook(Thread thread) {
        Runtime.getRuntime().removeShutdownHook(thread);
    }

    public static String getEnv(String key) {
        return System.getenv(key);
    }

    public static String getEnv(String key, String def) {
        return Objects1.def(System.getenv(key), def);
    }

    public static Map<String, String> getEnv() {
        return System.getenv();
    }

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        return System.getProperty(key, def);
    }

    public static Properties getProperties() {
        return System.getProperties();
    }

    public static String setProperty(String key, String value) {
        return System.setProperty(key, value);
    }

    public static void setProperty(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, String> clearProperty(List<String> keys) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            String value = System.clearProperty(key);
            map.put(key, value);
        }
        return map;
    }

    static {
        USER_NAME = Systems.getProperty("user.name", "unknown");
        FILE_ENCODING = Systems.getProperty("file.encoding", "UTF-8");
        HOME_DIR = Systems.getProperty("user.home", "/");
        USER_DIR = Systems.getProperty("user.dir", "/");
        TEMP_DIR = Systems.getProperty("java.io.tmpdir", "/");
        OS_NAME = Systems.getProperty("os.name", "unknown");
        OS_VERSION = Systems.getProperty("os.version", "unknown");
        JAVA_HOME = Systems.getProperty("java.home", "/");
        HOST_NAME = BE_WINDOWS ? Systems.getEnv("COMPUTERNAME") : Systems.getEnv("HOSTNAME");
        boolean beAndroid = true;
        try {
            Class.forName("android.util.Log");
        }
        catch (Exception e) {
            beAndroid = false;
        }
        BE_ANDROID = beAndroid;
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String processName = runtimeBean.getName();
        int si = processName.indexOf(64);
        if (si != -1) {
            processName = processName.substring(0, si);
        }
        PID = Integer.parseInt(processName);
        JAVA_SPEC_VERSION = runtimeBean.getSpecVersion();
        Runtime runtime = Runtime.getRuntime();
        PROCESS_NUM = runtime.availableProcessors();
        SEED = Randoms.randomInt(100000000, 999999999);
    }
}

