/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.define.Console;
import cn.orionsec.kit.lang.define.thread.ConcurrentCallable;
import cn.orionsec.kit.lang.define.thread.ConcurrentRunnable;
import cn.orionsec.kit.lang.define.thread.ExecutorBuilder;
import cn.orionsec.kit.lang.define.thread.HookRunnable;
import cn.orionsec.kit.lang.define.thread.NamedThreadFactory;
import cn.orionsec.kit.lang.define.thread.TaskCollector;
import cn.orionsec.kit.lang.define.wrapper.Tuple;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Systems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Threads {
    public static final ExecutorService GLOBAL_EXECUTOR = ExecutorBuilder.create().namedThreadFactory("orion-global-thread-").corePoolSize(Systems.PROCESS_NUM).maxPoolSize(Systems.PROCESS_NUM).keepAliveTime(60000L).workQueue(new LinkedBlockingQueue<Runnable>()).allowCoreThreadTimeout(true).build();
    public static final ExecutorService CACHE_EXECUTOR = ExecutorBuilder.create().namedThreadFactory("orion-cache-thread-").corePoolSize(1).maxPoolSize(Integer.MAX_VALUE).keepAliveTime(60000L).workQueue(new SynchronousQueue<Runnable>()).allowCoreThreadTimeout(true).build();

    private Threads() {
    }

    public static void start(Runnable r) {
        GLOBAL_EXECUTOR.execute(r);
    }

    public static void start(Runnable r, Executor pool) {
        if (pool == null) {
            pool = GLOBAL_EXECUTOR;
        }
        pool.execute(r);
    }

    public static void start(Collection<Runnable> rs, Executor pool) {
        Assert.notEmpty(rs, "task is empty", new Object[0]);
        if (pool == null) {
            pool = GLOBAL_EXECUTOR;
        }
        for (Runnable r : rs) {
            pool.execute(r);
        }
    }

    public static <V> Future<V> call(Callable<V> c) {
        return GLOBAL_EXECUTOR.submit(c);
    }

    public static <V> Future<V> call(Callable<V> c, ExecutorService pool) {
        if (pool == null) {
            pool = GLOBAL_EXECUTOR;
        }
        return pool.submit(c);
    }

    public static <V> List<Future<V>> call(Collection<? extends Callable<V>> cs, ExecutorService pool) {
        Assert.notEmpty(cs, "task is empty", new Object[0]);
        if (pool == null) {
            pool = GLOBAL_EXECUTOR;
        }
        ArrayList<Future<V>> list = new ArrayList<Future<V>>();
        for (Callable<V> c : cs) {
            list.add(pool.submit(c));
        }
        return list;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw Exceptions.interruptedRuntime(e);
        }
    }

    public static void sleep(long duration, TimeUnit unit) {
        try {
            unit.sleep(duration);
        }
        catch (InterruptedException e) {
            throw Exceptions.interruptedRuntime(e);
        }
    }

    public static Tuple collect(Callable<?> ... tasks) {
        return new TaskCollector(GLOBAL_EXECUTOR).tasks(tasks).collect();
    }

    public static void blockRun(Runnable r, int count, Executor pool) throws InterruptedException {
        Threads.blockRun(r, new CountDownLatch(count), pool);
    }

    public static void blockRun(Runnable r, CountDownLatch c, Executor pool) throws InterruptedException {
        Assert.notNull(r, "task is null", new Object[0]);
        if (pool == null) {
            pool = GLOBAL_EXECUTOR;
        }
        long count = c.getCount();
        int i = 0;
        while ((long)i < count) {
            pool.execute(new HookRunnable(r, c::countDown));
            ++i;
        }
        c.await();
    }

    public static void blockRun(Collection<? extends Runnable> rs, Executor pool) throws InterruptedException {
        Assert.notEmpty(rs, "task is empty", new Object[0]);
        if (pool == null) {
            pool = GLOBAL_EXECUTOR;
        }
        CountDownLatch c = new CountDownLatch(rs.size());
        for (Runnable runnable : rs) {
            pool.execute(new HookRunnable(runnable, c::countDown));
        }
        c.await();
    }

    public static CyclicBarrier concurrent(Runnable r, int count, Executor pool) {
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        CyclicBarrier cb = new CyclicBarrier(count);
        ConcurrentRunnable cr = new ConcurrentRunnable(r, cb);
        for (int i = 0; i < count; ++i) {
            pool.execute(cr);
        }
        return cb;
    }

    public static void concurrent(Runnable r, Executor pool, CyclicBarrier cb) {
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        int count = cb.getParties();
        ConcurrentRunnable cr = new ConcurrentRunnable(r, cb);
        for (int i = 0; i < count; ++i) {
            pool.execute(cr);
        }
    }

    public static void concurrent(Runnable r, Executor pool, CountDownLatch cd) {
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        ConcurrentRunnable cr = new ConcurrentRunnable(r, cd);
        long count = cd.getCount();
        int i = 0;
        while ((long)i < count) {
            pool.execute(cr);
            cd.countDown();
            ++i;
        }
    }

    public static <V> List<Future<V>> concurrent(Callable<V> c, int count, ExecutorService pool) {
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        ArrayList<Future<V>> list = new ArrayList<Future<V>>(count);
        CyclicBarrier cb = new CyclicBarrier(count);
        ConcurrentCallable<V> cc = new ConcurrentCallable<V>(c, cb);
        for (int i = 0; i < count; ++i) {
            list.add(pool.submit(cc));
        }
        return list;
    }

    public static <V> List<Future<V>> concurrent(Callable<V> c, ExecutorService pool, CyclicBarrier cb) {
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        int count = cb.getParties();
        ArrayList<Future<V>> list = new ArrayList<Future<V>>();
        ConcurrentCallable<V> cc = new ConcurrentCallable<V>(c, cb);
        for (int i = 0; i < count; ++i) {
            list.add(pool.submit(cc));
        }
        return list;
    }

    public static <V> List<Future<V>> concurrent(Callable<V> c, ExecutorService pool, CountDownLatch cd) {
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        long count = cd.getCount();
        ArrayList<Future<V>> list = new ArrayList<Future<V>>();
        ConcurrentCallable<V> cc = new ConcurrentCallable<V>(c, cd);
        int i = 0;
        while ((long)i < count) {
            list.add(pool.submit(cc));
            cd.countDown();
            ++i;
        }
        return list;
    }

    public static void concurrentRunnable(Collection<? extends Runnable> rs, Executor pool) {
        Assert.notEmpty(rs, "task is empty", new Object[0]);
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        CyclicBarrier cb = new CyclicBarrier(rs.size());
        for (Runnable runnable : rs) {
            ConcurrentRunnable cr = new ConcurrentRunnable(runnable, cb);
            pool.execute(cr);
        }
    }

    public static <V> List<Future<V>> concurrentCallable(Collection<? extends Callable<V>> cs, ExecutorService pool) {
        Assert.notEmpty(cs, "task is empty", new Object[0]);
        if (pool == null) {
            pool = CACHE_EXECUTOR;
        }
        ArrayList<Future<V>> list = new ArrayList<Future<V>>();
        CyclicBarrier cb = new CyclicBarrier(cs.size());
        for (Callable<V> c : cs) {
            ConcurrentCallable<V> cr = new ConcurrentCallable<V>(c, cb);
            list.add(pool.submit(cr));
        }
        return list;
    }

    public static void shutdownPool(ExecutorService pool, int shutdownTimeout) {
        Threads.shutdownPool(pool, shutdownTimeout, shutdownTimeout, TimeUnit.MILLISECONDS);
    }

    public static void shutdownPool(ExecutorService pool, int shutdownTimeout, TimeUnit timeUnit) {
        Threads.shutdownPool(pool, shutdownTimeout, shutdownTimeout, timeUnit);
    }

    public static void shutdownPool(ExecutorService pool, int shutdownTimeout, int shutdownNowTimeout) {
        Threads.shutdownPool(pool, shutdownTimeout, shutdownNowTimeout, TimeUnit.MILLISECONDS);
    }

    public static void shutdownPool(ExecutorService pool, int shutdownTimeout, int shutdownNowTimeout, TimeUnit timeUnit) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(shutdownTimeout, timeUnit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(shutdownNowTimeout, timeUnit)) {
                    Console.error("thread pool did not terminated");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static void shutdownPoolNow(ExecutorService pool, int timeout) {
        try {
            pool.shutdownNow();
            if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                Console.error("thread pool did not terminated");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public static void shutdownPoolNow(ExecutorService pool, int timeout, TimeUnit timeUnit) {
        try {
            pool.shutdownNow();
            if (!pool.awaitTermination(timeout, timeUnit)) {
                Console.error("thread pool did not terminated");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public static ExecutorService newThreadPool(int core, int max, int keepMilli, BlockingQueue<Runnable> workQueue, String prefix) {
        return new ThreadPoolExecutor(core, max, (long)keepMilli, TimeUnit.MILLISECONDS, workQueue, new NamedThreadFactory(prefix));
    }

    public static ExecutorService newThreadPool(int core, int max, int keepMilli, BlockingQueue<Runnable> workQueue, String prefix, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(core, max, keepMilli, TimeUnit.MILLISECONDS, workQueue, new NamedThreadFactory(prefix), handler);
    }

    static {
        Systems.addShutdownHook(() -> {
            Threads.shutdownPoolNow(GLOBAL_EXECUTOR, 3000);
            Threads.shutdownPoolNow(CACHE_EXECUTOR, 3000);
        });
    }
}

