/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum VariableStyles {
    SMALL_HUMP{

        @Override
        public String toSpine(String variable) {
            return VariableStyles.styleConvert(variable, VariableStyles.SPINE_TOKENIZER);
        }

        @Override
        public String toSerpentine(String variable) {
            return VariableStyles.styleConvert(variable, VariableStyles.SERPENTINE_TOKENIZER);
        }

        @Override
        public String toBigHump(String variable) {
            return VariableStyles.styleConvert(variable, 0);
        }

        @Override
        public String toSmallHump(String variable) {
            return variable;
        }
    }
    ,
    BIG_HUMP{

        @Override
        public String toSpine(String variable) {
            return VariableStyles.styleConvert(variable, VariableStyles.SPINE_TOKENIZER);
        }

        @Override
        public String toSerpentine(String variable) {
            return VariableStyles.styleConvert(variable, VariableStyles.SERPENTINE_TOKENIZER);
        }

        @Override
        public String toBigHump(String variable) {
            return variable;
        }

        @Override
        public String toSmallHump(String variable) {
            return VariableStyles.styleConvert(variable, 1);
        }
    }
    ,
    SERPENTINE{

        @Override
        public String toSpine(String variable) {
            return VariableStyles.styleConvert(variable, VariableStyles.SERPENTINE_TOKENIZER, VariableStyles.SPINE_TOKENIZER);
        }

        @Override
        public String toSerpentine(String variable) {
            return variable;
        }

        @Override
        public String toBigHump(String variable) {
            return VariableStyles.styleConvert(variable, false);
        }

        @Override
        public String toSmallHump(String variable) {
            return VariableStyles.styleConvert(variable, true);
        }
    }
    ,
    SPINE{

        @Override
        public String toSpine(String variable) {
            return variable;
        }

        @Override
        public String toSerpentine(String variable) {
            return VariableStyles.styleConvert(variable, VariableStyles.SPINE_TOKENIZER, VariableStyles.SERPENTINE_TOKENIZER);
        }

        @Override
        public String toBigHump(String variable) {
            return VariableStyles.styleConvert(variable, false);
        }

        @Override
        public String toSmallHump(String variable) {
            return VariableStyles.styleConvert(variable, true);
        }
    };

    private static final String SPINE_TOKENIZER = "-";
    private static final String SERPENTINE_TOKENIZER = "_";
    private static final Pattern BIG_HUMP_PATTERN;
    private static final Pattern SERPENTINE_PATTERN;
    private static final Pattern SPINE_PATTERN;

    public static String convert(String variable, VariableStyles e) {
        if (Strings.isBlank(variable)) {
            return variable;
        }
        VariableStyles styleType = VariableStyles.getType(variable);
        if (e == styleType) {
            return variable;
        }
        switch (styleType) {
            case SMALL_HUMP: {
                switch (e) {
                    case BIG_HUMP: {
                        return VariableStyles.styleConvert(variable, 0);
                    }
                    case SERPENTINE: {
                        return VariableStyles.styleConvert(variable, SERPENTINE_TOKENIZER);
                    }
                    case SPINE: {
                        return VariableStyles.styleConvert(variable, SPINE_TOKENIZER);
                    }
                }
                return variable;
            }
            case BIG_HUMP: {
                switch (e) {
                    case SMALL_HUMP: {
                        return VariableStyles.styleConvert(variable, 1);
                    }
                    case SERPENTINE: {
                        return VariableStyles.styleConvert(variable, SERPENTINE_TOKENIZER);
                    }
                    case SPINE: {
                        return VariableStyles.styleConvert(variable, SPINE_TOKENIZER);
                    }
                }
                return variable;
            }
            case SERPENTINE: {
                switch (e) {
                    case SMALL_HUMP: {
                        return VariableStyles.styleConvert(variable, true);
                    }
                    case BIG_HUMP: {
                        return VariableStyles.styleConvert(variable, false);
                    }
                    case SPINE: {
                        return VariableStyles.styleConvert(variable, SERPENTINE_TOKENIZER, SPINE_TOKENIZER);
                    }
                }
                return variable;
            }
            case SPINE: {
                switch (e) {
                    case SMALL_HUMP: {
                        return VariableStyles.styleConvert(variable, true);
                    }
                    case BIG_HUMP: {
                        return VariableStyles.styleConvert(variable, false);
                    }
                    case SERPENTINE: {
                        return VariableStyles.styleConvert(variable, SPINE_TOKENIZER, SERPENTINE_TOKENIZER);
                    }
                }
                return variable;
            }
        }
        return variable;
    }

    private static String styleConvert(String variable, String before, String after) {
        return variable.toLowerCase().replaceAll(before, after);
    }

    private static String styleConvert(String variable, String tokenizer) {
        variable = String.valueOf(variable.charAt(0)).toUpperCase().concat(variable.substring(1));
        StringBuilder sb = new StringBuilder();
        Matcher matcher = BIG_HUMP_PATTERN.matcher(variable);
        while (matcher.find()) {
            sb.append(matcher.group().toLowerCase()).append(matcher.end() == variable.length() ? "" : tokenizer);
        }
        return sb.toString();
    }

    private static String styleConvert(String variable, boolean small) {
        Pattern pattern;
        String tokenizer;
        if (variable.contains(SPINE_TOKENIZER)) {
            tokenizer = SPINE_TOKENIZER;
            pattern = SPINE_PATTERN;
        } else {
            tokenizer = SERPENTINE_TOKENIZER;
            pattern = SERPENTINE_PATTERN;
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(variable);
        int i = 0;
        while (matcher.find()) {
            String word = matcher.group();
            if (++i == 1 && small) {
                sb.append(Character.toLowerCase(word.charAt(0)));
            } else {
                sb.append(Character.toUpperCase(word.charAt(0)));
            }
            int index = word.lastIndexOf(tokenizer);
            if (index > 0) {
                sb.append(word, 1, index);
                continue;
            }
            sb.append(word.substring(1));
        }
        return sb.toString();
    }

    private static String styleConvert(String variable, int t) {
        if (t == 0) {
            return Character.toUpperCase(variable.charAt(0)) + variable.substring(1);
        }
        return Character.toLowerCase(variable.charAt(0)) + variable.substring(1);
    }

    private static VariableStyles getType(String variable) {
        if (Strings.isBlank(variable)) {
            return SMALL_HUMP;
        }
        if (variable.contains(SERPENTINE_TOKENIZER)) {
            return SERPENTINE;
        }
        if (variable.contains(SPINE_TOKENIZER)) {
            return SPINE;
        }
        char f = variable.charAt(0);
        if (f >= 'A' && f <= 'Z') {
            return BIG_HUMP;
        }
        return SMALL_HUMP;
    }

    public abstract String toSmallHump(String var1);

    public abstract String toBigHump(String var1);

    public abstract String toSerpentine(String var1);

    public abstract String toSpine(String var1);

    static {
        BIG_HUMP_PATTERN = Pattern.compile("[A-Z]([a-z\\d]+)?");
        SERPENTINE_PATTERN = Pattern.compile("([A-Za-z\\d]+)(_)?");
        SPINE_PATTERN = Pattern.compile("([A-Za-z\\d]+)(-)?");
    }
}

