/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.awt;

import cn.orionsec.kit.lang.able.Awaitable;
import cn.orionsec.kit.lang.utils.Colors;
import cn.orionsec.kit.lang.utils.awt.Images;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageMargins
implements Awaitable<BufferedImage> {
    private final BufferedImage image;
    private Color color;
    private boolean transparent;
    private int topMargin;
    private int rightMargin;
    private int bottomMargin;
    private int leftMargin;

    public ImageMargins(BufferedImage image) {
        this.image = image;
    }

    @Override
    public BufferedImage await() {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int newWidth = width + this.rightMargin + this.leftMargin;
        int newHeight = height + this.topMargin + this.bottomMargin;
        BufferedImage s = this.transparent ? Images.getTransparentImage(newWidth, newHeight) : new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = s.createGraphics();
        if (!this.transparent) {
            if (this.color == null) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(this.color);
            }
            g2d.fillRect(0, 0, newWidth, newHeight);
        }
        g2d.drawImage(this.image, this.leftMargin, this.topMargin, width, height, null);
        g2d.dispose();
        return s;
    }

    public ImageMargins transparent() {
        this.transparent = true;
        return this;
    }

    public ImageMargins color(int r, int g, int b) {
        this.color = Colors.toColor(r, g, b);
        this.transparent = false;
        return this;
    }

    public ImageMargins color(String hex) {
        this.color = Colors.toColor(hex);
        this.transparent = false;
        return this;
    }

    public ImageMargins color(Color color) {
        this.color = color;
        this.transparent = false;
        return this;
    }

    public ImageMargins margin(int margin) {
        this.topMargin = margin;
        this.rightMargin = margin;
        this.bottomMargin = margin;
        this.leftMargin = margin;
        return this;
    }

    public ImageMargins margin(int topBottom, int rightLeft) {
        this.topMargin = topBottom;
        this.rightMargin = rightLeft;
        this.bottomMargin = topBottom;
        this.leftMargin = rightLeft;
        return this;
    }

    public ImageMargins margin(int topMargin, int rightMargin, int bottomMargin, int leftMargin) {
        this.topMargin = topMargin;
        this.rightMargin = rightMargin;
        this.bottomMargin = bottomMargin;
        this.leftMargin = leftMargin;
        return this;
    }

    public ImageMargins topMargin(int topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    public ImageMargins rightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    public ImageMargins bottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    public ImageMargins leftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Color getColor() {
        return this.color;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }
}

