/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.codec;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Strings;
import java.io.ByteArrayOutputStream;

public class Base62s {
    private static final int STANDARD_BASE = 256;
    private static final int TARGET_BASE = 62;
    private static final byte[] GMP = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] INVERTED = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final Base62s GMP_ENCODE = new Base62s(GMP);
    private static final Base62s GMP_INVERTED_ENCODE = new Base62s(INVERTED);
    private final byte[] alphabet;
    private final byte[] lookup;

    private Base62s(byte[] alphabet) {
        this.alphabet = alphabet;
        this.lookup = new byte[256];
        for (int i = 0; i < alphabet.length; ++i) {
            this.lookup[alphabet[i]] = (byte)(i & 0xFF);
        }
    }

    public static String encode(String s) {
        return new String(Base62s.encode(Strings.bytes(s), true));
    }

    public static String encode(String s, boolean gmp) {
        return new String(Base62s.encode(Strings.bytes(s), gmp));
    }

    public static byte[] encode(byte[] bs) {
        return Base62s.encode(bs, true);
    }

    public static byte[] encode(byte[] bs, boolean gmp) {
        return gmp ? GMP_ENCODE.encodeBytes(bs) : GMP_INVERTED_ENCODE.encodeBytes(bs);
    }

    public static String decode(String s) {
        return new String(Base62s.decode(Strings.bytes(s), true));
    }

    public static String decode(String s, boolean gmp) {
        return new String(Base62s.decode(Strings.bytes(s), gmp));
    }

    public static byte[] decode(byte[] bs) {
        return Base62s.decode(bs, true);
    }

    public static byte[] decode(byte[] bs, boolean gmp) {
        return gmp ? GMP_ENCODE.decodeBytes(bs) : GMP_INVERTED_ENCODE.decodeBytes(bs);
    }

    private byte[] encodeBytes(byte[] bs) {
        byte[] indices = this.convert(bs, 256, 62);
        return this.translate(indices, this.alphabet);
    }

    private byte[] decodeBytes(byte[] encoded) {
        byte[] prepared = this.translate(encoded, this.lookup);
        return this.convert(prepared, 62, 256);
    }

    private byte[] translate(byte[] indices, byte[] dictionary) {
        byte[] translation = new byte[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            translation[i] = dictionary[indices[i]];
        }
        return translation;
    }

    private byte[] convert(byte[] message, int sourceBase, int targetBase) {
        int estimatedLength = this.estimateOutputLength(message.length, sourceBase, targetBase);
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] source = message;
        while (source.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte b : source) {
                int accumulator = (b & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                remainder = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            source = quotient.toByteArray();
        }
        for (int i = 0; i < message.length - 1 && message[i] == 0; ++i) {
            out.write(0);
        }
        byte[] bytes = out.toByteArray();
        Arrays1.reverse(bytes);
        return bytes;
    }

    private int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
        return (int)Math.ceil(Math.log(sourceBase) / Math.log(targetBase) * (double)inputLength);
    }
}

