/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.collect;

import cn.orionsec.kit.lang.define.collect.EmptyList;
import cn.orionsec.kit.lang.define.collect.FixedArrayList;
import cn.orionsec.kit.lang.define.collect.LimitList;
import cn.orionsec.kit.lang.define.collect.MutableArrayList;
import cn.orionsec.kit.lang.define.collect.MutableLinkedList;
import cn.orionsec.kit.lang.define.collect.MutableVector;
import cn.orionsec.kit.lang.define.collect.PartitionList;
import cn.orionsec.kit.lang.define.collect.SingletonList;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.collect.Collections;
import cn.orionsec.kit.lang.utils.random.Randoms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;

public class Lists
extends Collections {
    private Lists() {
    }

    public static <E> List<E> newList() {
        return new ArrayList();
    }

    public static <E> List<E> newList(int capacity) {
        return new ArrayList(capacity);
    }

    public static <E> List<E> newList(Collection<? extends E> c) {
        if (c == null) {
            return new ArrayList();
        }
        return new ArrayList<E>(c);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(Collection<? extends E> c) {
        if (c == null) {
            return new LinkedList();
        }
        return new LinkedList<E>(c);
    }

    public static <E> MutableArrayList<E> newMutableList() {
        return new MutableArrayList();
    }

    public static <E> MutableArrayList<E> newMutableList(int capacity) {
        return new MutableArrayList(capacity);
    }

    public static <E> MutableArrayList<E> newMutableList(Collection<? extends E> c) {
        if (c == null) {
            return new MutableArrayList();
        }
        return new MutableArrayList<E>(c);
    }

    public static <E> MutableLinkedList<E> newMutableLinkedList() {
        return new MutableLinkedList();
    }

    public static <E> MutableLinkedList<E> newMutableLinkedList(Collection<? extends E> c) {
        if (c == null) {
            return new MutableLinkedList();
        }
        return new MutableLinkedList<E>(c);
    }

    public static <E> MutableVector<E> newMutableVector() {
        return new MutableVector();
    }

    public static <E> MutableVector<E> newMutableVector(int initialCapacity) {
        return new MutableVector(initialCapacity);
    }

    public static <E> MutableVector<E> newMutableVector(int initialCapacity, int capacityIncrement) {
        return new MutableVector(initialCapacity, capacityIncrement);
    }

    public static <E> MutableVector<E> newMutableVector(Collection<? extends E> c) {
        if (c == null) {
            return new MutableVector();
        }
        return new MutableVector<E>(c);
    }

    public static <E> FixedArrayList<E> newFixedList(int limit) {
        return new FixedArrayList(limit);
    }

    public static <E> LimitList<E> newLimitList() {
        return new LimitList();
    }

    public static <E> LimitList<E> newLimitList(int limit) {
        return new LimitList(limit);
    }

    public static <E> LimitList<E> newLimitList(int initialCapacity, int limit) {
        return new LimitList(initialCapacity, limit);
    }

    public static <E> LimitList<E> newLimitList(Collection<? extends E> c) {
        return new LimitList<E>(c);
    }

    public static <E> LimitList<E> newLimitList(Collection<? extends E> c, int limit) {
        return new LimitList<E>(c, limit);
    }

    public static <E> List<E> newCopyOnWriteList() {
        return new CopyOnWriteArrayList();
    }

    public static <E> List<E> newCopyOnWriteList(E[] array) {
        return new CopyOnWriteArrayList<E>(array);
    }

    public static <E> List<E> newCopyOnWriteList(Collection<? extends E> c) {
        if (c == null) {
            return new CopyOnWriteArrayList();
        }
        return new CopyOnWriteArrayList<E>(c);
    }

    public static <E> List<E> newSynchronizedList() {
        return java.util.Collections.synchronizedList(new ArrayList());
    }

    public static <E> List<E> newSynchronizedList(List<E> list) {
        if (list == null) {
            return java.util.Collections.synchronizedList(new ArrayList());
        }
        return java.util.Collections.synchronizedList(list);
    }

    public static <E> List<E> unmodified(List<E> list) {
        return java.util.Collections.unmodifiableList(list);
    }

    public static <E> List<E> singleton(E e) {
        return new SingletonList<E>(e);
    }

    public static <E> List<E> singletonNullable(E e) {
        ArrayList<E> list = new ArrayList<E>();
        if (e != null) {
            list.add(e);
        }
        return list;
    }

    public static <E> List<E> empty() {
        return EmptyList.EMPTY;
    }

    public static <E> List<E> def(List<E> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <E> List<E> def(List<E> list, List<E> def) {
        return list == null ? def : list;
    }

    public static <E> List<E> def(List<E> list, Supplier<List<E>> def) {
        return list == null ? def.get() : list;
    }

    @SafeVarargs
    public static <E> List<E> of(E ... values) {
        return new ArrayList<E>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <E, V> List<E> of(Function<V, E> mapper, V ... values) {
        Assert.notNull(mapper, "convert function is null", new Object[0]);
        ArrayList<E> list = new ArrayList<E>();
        int length = Arrays1.length(values);
        for (int i = 0; i < length; ++i) {
            list.add(mapper.apply(values[i]));
        }
        return list;
    }

    public static <E, V> List<E> map(List<V> list, Function<V, E> mapper) {
        Assert.notNull(mapper, "convert function is null", new Object[0]);
        ArrayList<E> result = new ArrayList<E>();
        if (Lists.isEmpty(list)) {
            return result;
        }
        for (V v : list) {
            result.add(mapper.apply(v));
        }
        return result;
    }

    public static <E> List<E> as(Iterator<E> iterator) {
        ArrayList<E> list = new ArrayList<E>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list;
    }

    public static <E> List<E> as(Enumeration<E> iterator) {
        ArrayList<E> list = new ArrayList<E>();
        if (iterator != null) {
            while (iterator.hasMoreElements()) {
                list.add(iterator.nextElement());
            }
        }
        return list;
    }

    public static <E> void cutAfter(List<E> list, int len) {
        Lists.cutAround(list, 0, len);
    }

    public static <E> void cutBefore(List<E> list, int len) {
        Lists.cutAround(list, Lists.size(list) - len, len);
    }

    public static <E> void cutAround(List<E> list, int start, int len) {
        int size = Lists.size(list);
        if (size >= len + start) {
            for (int i = size - len - start; i > 0; --i) {
                list.remove(len + i - 1);
            }
            if (start > 0) {
                list.subList(0, start).clear();
            }
        } else {
            throw Exceptions.index("cut list error: startIndex: " + start + ", cutLength: " + len + ", needSize: " + (start + len) + ", but maxSize: " + size);
        }
    }

    @SafeVarargs
    public static <E> void merge(List<E> source, List<E> ... listArray) {
        if (listArray == null) {
            return;
        }
        for (List<E> m : listArray) {
            if (m == null) continue;
            source.addAll(m);
        }
    }

    public static <E> E random(List<E> list) {
        int size = Lists.size(list);
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return list.get(0);
        }
        return list.get(Randoms.RANDOM.nextInt(size));
    }

    public static <E> void reverse(List<E> list) {
        int size = Lists.size(list);
        if (size == 0) {
            return;
        }
        int mid = size / 2;
        for (int i = 0; i < mid; ++i) {
            int len = size - i - 1;
            if (list.get(i) == list.get(len)) continue;
            list.set(len, list.set(i, list.get(len)));
        }
    }

    public static <E> int indexOf(List<E> list, E e) {
        if (Lists.isEmpty(list)) {
            return -1;
        }
        return list.indexOf(e);
    }

    public static <E> int lastIndexOf(List<E> list, E e) {
        if (Lists.isEmpty(list)) {
            return -1;
        }
        return list.lastIndexOf(e);
    }

    public static boolean eq(List<?> list1, List<?> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        int size = Lists.size(list1);
        if (size != Lists.size(list2)) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (Objects1.eq(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <E> void removeToSize(List<E> list, int size) {
        int beforeSize = Lists.size(list);
        if (size >= beforeSize) {
            return;
        }
        list.subList(size, beforeSize).clear();
    }

    public static <E> List<List<E>> partition(List<E> list, int size) {
        return new PartitionList<E>(list, size);
    }

    public static <E> List<E> distinct(Collection<E> c, Function<E, ?> keyGetter) {
        return new ArrayList<E>(Collections.distinct(c, keyGetter));
    }

    public static <E> E getIfPresent(List<E> list, int i) {
        int size = Lists.size(list);
        if (size == 0) {
            return null;
        }
        if (i >= size) {
            return null;
        }
        return list.get(i);
    }

    public static <E> E get(List<E> list, int i) {
        int size = Lists.size(list);
        if (size == 0) {
            return null;
        }
        if (i >= size) {
            throw Exceptions.index("list length: " + size + " get index: " + i);
        }
        return list.get(i);
    }

    public static <E> void set(List<E> list, int i, E e) {
        Lists.sets(list, i, e, true);
    }

    public static <E> void set(List<E> list, int i, E e, boolean force) {
        Lists.sets(list, i, e, force);
    }

    public static <E> void setex(List<E> list, int i, E e) {
        Lists.sets(list, i, e, false);
    }

    public static <E> E getSet(List<E> list, int i, E e) {
        return Lists.sets(list, i, e, true);
    }

    private static <E> E sets(List<E> list, int i, E e, boolean force) {
        int size = Lists.size(list);
        if (size == 0) {
            return null;
        }
        if (i >= size) {
            throw Exceptions.index("list length: " + size + " get index: " + i);
        }
        E o = list.get(i);
        if (force) {
            list.set(i, e);
            return o;
        }
        if (o == null) {
            list.set(i, e);
        }
        return null;
    }

    public static byte[] toBytes(List<Byte> list) {
        int size = Lists.size(list);
        byte[] arr = new byte[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static short[] toShorts(List<Short> list) {
        int size = Lists.size(list);
        short[] arr = new short[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static int[] toInts(List<Integer> list) {
        int size = Lists.size(list);
        int[] arr = new int[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static long[] toLongs(List<Long> list) {
        int size = Lists.size(list);
        long[] arr = new long[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static float[] toFloats(List<Float> list) {
        int size = Lists.size(list);
        float[] arr = new float[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i).floatValue();
        }
        return arr;
    }

    public static double[] toDoubles(List<Double> list) {
        int size = Lists.size(list);
        double[] arr = new double[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static boolean[] toBooleans(List<Boolean> list) {
        int size = Lists.size(list);
        boolean[] arr = new boolean[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static char[] toChars(List<Character> list) {
        int size = Lists.size(list);
        char[] arr = new char[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i).charValue();
        }
        return arr;
    }

    public static <T> void copy(List<? extends T> src, List<? super T> target) {
        int srcSize = Lists.size(src);
        int distSize = Lists.size(target);
        int size = Math.min(srcSize, distSize);
        if (srcSize < 10 || src instanceof RandomAccess && target instanceof RandomAccess) {
            for (int i = 0; i < size; ++i) {
                target.set(i, src.get(i));
            }
        } else {
            ListIterator<T> ti = target.listIterator();
            ListIterator<T> si = src.listIterator();
            for (int i = 0; i < size; ++i) {
                ti.next();
                ti.set(si.next());
            }
        }
    }
}

