/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.collect;

import cn.orionsec.kit.lang.define.collect.ConcurrentReferenceHashMap;
import cn.orionsec.kit.lang.define.collect.EmptyMap;
import cn.orionsec.kit.lang.define.collect.MutableConcurrentHashMap;
import cn.orionsec.kit.lang.define.collect.MutableHashMap;
import cn.orionsec.kit.lang.define.collect.MutableLinkedHashMap;
import cn.orionsec.kit.lang.define.collect.MutableTreeMap;
import cn.orionsec.kit.lang.define.collect.PartitionMap;
import cn.orionsec.kit.lang.define.collect.SingletonMap;
import cn.orionsec.kit.lang.define.wrapper.Pair;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.math.Numbers;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Maps {
    private Maps() {
    }

    public static <K, V> Map<K, V> newMap() {
        return new HashMap(16);
    }

    public static <K, V> Map<K, V> newMap(int capacity) {
        return new HashMap(capacity);
    }

    public static <K, V> Map<K, V> newMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new HashMap(16);
        }
        return new HashMap<K, V>(m);
    }

    public static <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new TreeMap();
        }
        return new TreeMap<K, V>(m);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedMap() {
        return new LinkedHashMap(16);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedMap(int capacity) {
        return new LinkedHashMap(capacity);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new LinkedHashMap(16);
        }
        return new LinkedHashMap<K, V>(m);
    }

    public static <K, V> ConcurrentHashMap<K, V> newCurrentHashMap() {
        return new ConcurrentHashMap(16);
    }

    public static <K, V> ConcurrentHashMap<K, V> newCurrentHashMap(int capacity) {
        return new ConcurrentHashMap(capacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newCurrentHashMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new ConcurrentHashMap(16);
        }
        return new ConcurrentHashMap<K, V>(m);
    }

    public static <K, V> MutableHashMap<K, V> newMutableMap() {
        return new MutableHashMap(16);
    }

    public static <K, V> MutableHashMap<K, V> newMutableMap(int capacity) {
        return new MutableHashMap(capacity);
    }

    public static <K, V> MutableHashMap<K, V> newMutableMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new MutableHashMap(16);
        }
        return new MutableHashMap<K, V>(m);
    }

    public static <K, V> MutableTreeMap<K, V> newMutableTreeMap() {
        return new MutableTreeMap();
    }

    public static <K, V> MutableTreeMap<K, V> newMutableTreeMap(Comparator<? super K> comparator) {
        return new MutableTreeMap(comparator);
    }

    public static <K, V> MutableTreeMap<K, V> newMutableTreeMap(SortedMap<K, ? extends V> m) {
        if (m == null) {
            return new MutableTreeMap();
        }
        return new MutableTreeMap<K, V>(m);
    }

    public static <K, V> MutableTreeMap<K, V> newMutableTreeMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new MutableTreeMap();
        }
        return new MutableTreeMap<K, V>(m);
    }

    public static <K, V> MutableLinkedHashMap<K, V> newMutableLinkedMap() {
        return new MutableLinkedHashMap(16);
    }

    public static <K, V> MutableLinkedHashMap<K, V> newMutableLinkedMap(int capacity) {
        return new MutableLinkedHashMap(capacity);
    }

    public static <K, V> MutableLinkedHashMap<K, V> newMutableLinkedMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new MutableLinkedHashMap(16);
        }
        return new MutableLinkedHashMap<K, V>(m);
    }

    public static <K, V> MutableConcurrentHashMap<K, V> newMutableConcurrentHashMap() {
        return new MutableConcurrentHashMap(16);
    }

    public static <K, V> MutableConcurrentHashMap<K, V> newMutableConcurrentHashMap(int capacity) {
        return new MutableConcurrentHashMap(capacity);
    }

    public static <K, V> MutableConcurrentHashMap<K, V> newMutableConcurrentHashMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new MutableConcurrentHashMap(16);
        }
        return new MutableConcurrentHashMap<K, V>(m);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap(16);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(int capacity) {
        return new IdentityHashMap(capacity);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new IdentityHashMap(16);
        }
        return new IdentityHashMap<K, V>(m);
    }

    public static <K, V> WeakHashMap<K, V> newWeakHashMap() {
        return new WeakHashMap(16);
    }

    public static <K, V> WeakHashMap<K, V> newWeakHashMap(int capacity) {
        return new WeakHashMap(capacity);
    }

    public static <K, V> WeakHashMap<K, V> newWeakHashMap(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return new WeakHashMap(16);
        }
        return new WeakHashMap<K, V>(m);
    }

    public static <K, V> ConcurrentReferenceHashMap<K, V> newConcurrentWeakHashMap() {
        return new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    }

    public static <K, V> ConcurrentReferenceHashMap<K, V> newConcurrentWeakHashMap(int capacity) {
        return new ConcurrentReferenceHashMap(capacity, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    }

    public static <K, V> ConcurrentReferenceHashMap<K, V> newConcurrentSoftHashMap() {
        return new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    }

    public static <K, V> ConcurrentReferenceHashMap<K, V> newConcurrentSoftHashMap(int capacity) {
        return new ConcurrentReferenceHashMap(capacity, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    }

    public static <K, V> Map<K, V> newSynchronizedMap() {
        return Collections.synchronizedMap(new HashMap(16));
    }

    public static <K, V> Map<K, V> newSynchronizedMap(Map<K, V> m) {
        if (m == null) {
            return Collections.synchronizedMap(new HashMap(16));
        }
        return Collections.synchronizedMap(m);
    }

    public static <K, V> Map<K, V> unmodified(Map<? extends K, ? extends V> c) {
        return Collections.unmodifiableMap(c);
    }

    public static <K, V> SortedMap<K, V> unmodified(SortedMap<K, ? extends V> c) {
        return Collections.unmodifiableSortedMap(c);
    }

    public static <K, V> Map<K, V> singleton(K k, V v) {
        return new SingletonMap<K, V>(k, v);
    }

    public static <K, V> Map<K, V> empty() {
        return EmptyMap.EMPTY;
    }

    public static int getNoCapacitySize(int size) {
        if (size == 0) {
            return 16;
        }
        return Numbers.getMin2Power(size * 4 / 3);
    }

    public static <K, V> Map<K, V> def(Map<K, V> map) {
        return map == null ? new HashMap() : map;
    }

    public static <K, V> Map<K, V> def(Map<K, V> map, Map<K, V> def) {
        return map == null ? def : map;
    }

    public static <K, V> Map<K, V> def(Map<K, V> map, Supplier<Map<K, V>> def) {
        return map == null ? def.get() : map;
    }

    @SafeVarargs
    public static <E extends Map.Entry<K, V>, K, V> Map<K, V> of(E ... entries) {
        int len = Arrays1.length(entries);
        if (len == 0) {
            return new HashMap(16);
        }
        HashMap<K, V> map = new HashMap<K, V>(Maps.getNoCapacitySize(len));
        for (int i = 0; i < len; ++i) {
            map.put(entries[i].getKey(), entries[i].getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> of(K[] keys, V[] values) {
        int klen = Arrays1.length(keys);
        int vlen = Arrays1.length(values);
        if (klen == 0) {
            return new HashMap(16);
        }
        HashMap<K, V> map = new HashMap<K, V>(Maps.getNoCapacitySize(klen));
        for (int i = 0; i < klen; ++i) {
            if (vlen > i) {
                map.put(keys[i], values[i]);
                continue;
            }
            map.put(keys[i], null);
        }
        return map;
    }

    public static <K, V> Map<K, V> of(Object ... kv) {
        if (kv == null) {
            return new HashMap(16);
        }
        int c = kv.length / 2;
        int hn = kv.length % 2;
        HashMap<Object, Object> res = new HashMap<Object, Object>(Maps.getNoCapacitySize(hn == 0 ? c : c + 1));
        for (int i = 0; i < c; ++i) {
            res.put(kv[i * 2], kv[i * 2 + 1]);
        }
        if (hn == 1) {
            res.put(kv[c * 2], null);
        }
        return res;
    }

    public static <K1, K2, V> Map<K2, V> mapKey(Map<K1, V> map, Function<K1, K2> mapper) {
        return Maps.map(map, mapper, Function.identity());
    }

    public static <K, V1, V2> Map<K, V2> mapValue(Map<K, V1> map, Function<V1, V2> mapper) {
        return Maps.map(map, Function.identity(), mapper);
    }

    public static <K1, V1, K2, V2> Map<K2, V2> map(Map<K1, V1> map, Function<K1, K2> keyMapper, Function<V1, V2> valueMapper) {
        Assert.notNull(keyMapper, "key mapper function is null", new Object[0]);
        Assert.notNull(valueMapper, "value mapper function is null", new Object[0]);
        int size = Maps.size(map);
        if (size == 0) {
            return new HashMap(16);
        }
        HashMap res = new HashMap(Maps.getNoCapacitySize(size));
        map.forEach((k, v) -> res.put(keyMapper.apply(k), valueMapper.apply(v)));
        return res;
    }

    public static <K, V> void combine(Map<K, V> sourceMap, Map<K, V> addMap) {
        addMap.forEach((k, v) -> {
            Object sourceValue = sourceMap.get(k);
            if (sourceValue instanceof Map && v instanceof Map) {
                Maps.combine((Map)sourceValue, (Map)v);
            } else {
                sourceMap.put(k, v);
            }
        });
    }

    @SafeVarargs
    public static <K, V> void merge(Map<K, V> sourceMap, Map<K, V> ... mapArray) {
        if (mapArray == null) {
            return;
        }
        for (Map<K, V> map : mapArray) {
            sourceMap.putAll(map);
        }
    }

    public static int size(Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Maps.size(map) == 0;
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !Maps.isEmpty(map);
    }

    public static boolean isAllEmpty(Map<?, ?> ... mapArray) {
        if (mapArray == null) {
            return true;
        }
        for (Map<?, ?> m : mapArray) {
            if (Maps.isEmpty(m)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneEmpty(Map<?, ?> ... mapArray) {
        if (mapArray == null) {
            return false;
        }
        for (Map<?, ?> m : mapArray) {
            if (!Maps.isEmpty(m)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, Object> multiToSingleMap(Map<String, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Maps.multiToSingleMap(map, "", result);
        return result;
    }

    private static void multiToSingleMap(Map<String, ?> map, String nowKey, Map<String, Object> result) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Maps.multiToSingleMap((Map)value, nowKey + key + ".", result);
                continue;
            }
            result.put(nowKey + key, value);
        }
    }

    public static <K, V> Pair<K, V> random(Map<K, V> map) {
        int size = Maps.size(map);
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return Pair.of(map.entrySet().iterator().next());
        }
        Object randomKey = Arrays1.random(map.keySet().toArray());
        return new Pair<Object, V>(randomKey, map.get(randomKey));
    }

    public static <K, V> void fill(Map<K, V> map, V value) {
        if (!Maps.isEmpty(map)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                entry.setValue(value);
            }
        }
    }

    public static <K, V> V get(Map<K, V> map, K k) {
        int size = Maps.size(map);
        if (size == 0) {
            return null;
        }
        return map.get(k);
    }

    public static <K, V> void set(Map<K, V> map, K k, V v) {
        Maps.sets(map, k, v, true);
    }

    public static <K, V> void set(Map<K, V> map, K k, V v, boolean force) {
        Maps.sets(map, k, v, force);
    }

    public static <K, V> void setex(Map<K, V> map, K k, V v) {
        Maps.sets(map, k, v, false);
    }

    public static <K, V> V getSet(Map<K, V> map, K k, V v) {
        return Maps.sets(map, k, v, true);
    }

    private static <K, V> V sets(Map<K, V> map, K k, V v, boolean force) {
        int size = Maps.size(map);
        if (size == 0) {
            return null;
        }
        V o = map.get(k);
        if (force) {
            map.put(k, v);
            return o;
        }
        if (o == null) {
            map.put(k, v);
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> first(Map<K, V> m) {
        if (Maps.size(m) == 0) {
            return null;
        }
        return Lists.first(m.entrySet());
    }

    public static <K, V> Map.Entry<K, V> last(Map<K, V> map) {
        if (Maps.size(map) == 0) {
            return null;
        }
        return Lists.last(map.entrySet());
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<? super K, ? super V> action) {
        if (Maps.isEmpty(map)) {
            return;
        }
        map.forEach(action);
    }

    public static <K, V> Set<Map<K, V>> partition(Map<K, V> map, int size) {
        return new PartitionMap<K, V>(map, size);
    }
}

