/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.collect;

import cn.orionsec.kit.lang.define.collect.FixedDeque;
import cn.orionsec.kit.lang.define.collect.FixedQueue;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.collect.Collections;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;

public class Queues
extends Collections {
    private Queues() {
    }

    public static <E> Queue<E> newQueue() {
        return new ConcurrentLinkedQueue();
    }

    public static <E> Queue<E> newQueue(Collection<E> c) {
        return new ConcurrentLinkedQueue<E>(c);
    }

    public static <E> Deque<E> newDeque() {
        return new ConcurrentLinkedDeque();
    }

    public static <E> Deque<E> newDeque(Collection<E> c) {
        return new ConcurrentLinkedDeque<E>(c);
    }

    public static <E> Queue<E> newLimitQueue(int size) {
        return new FixedQueue(size);
    }

    public static <E> Deque<E> newLimitDeque(int size) {
        return new FixedDeque(size);
    }

    public static <E> Queue<E> def(Queue<E> queue) {
        return queue == null ? new ConcurrentLinkedQueue() : queue;
    }

    public static <E> Deque<E> def(Deque<E> queue) {
        return queue == null ? new ConcurrentLinkedDeque() : queue;
    }

    public static <E> Queue<E> def(Queue<E> queue, Queue<E> def) {
        return queue == null ? def : queue;
    }

    public static <E> Deque<E> def(Deque<E> queue, Deque<E> def) {
        return queue == null ? def : queue;
    }

    public static <E> Queue<E> def(Queue<E> queue, Supplier<Queue<E>> def) {
        return queue == null ? def.get() : queue;
    }

    public static <E> Deque<E> def(Deque<E> queue, Supplier<Deque<E>> def) {
        return queue == null ? def.get() : queue;
    }

    @SafeVarargs
    public static <E> Queue<E> of(E ... values) {
        return new ConcurrentLinkedQueue<E>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <E> Deque<E> ofd(E ... values) {
        return new ConcurrentLinkedDeque<E>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <E, V> Queue<E> of(Function<V, E> mapper, V ... values) {
        Assert.notNull(mapper, "convert function is null", new Object[0]);
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        int length = Arrays1.length(values);
        for (int i = 0; i < length; ++i) {
            q.add(mapper.apply(values[i]));
        }
        return q;
    }

    @SafeVarargs
    public static <E, V> Deque<E> ofd(Function<V, E> mapper, V ... e) {
        Assert.notNull(mapper, "convert function is null", new Object[0]);
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        int length = Arrays1.length(e);
        for (int i = 0; i < length; ++i) {
            q.add(mapper.apply(e[i]));
        }
        return q;
    }

    public static <E, V> Queue<E> map(Queue<V> queue, Function<V, E> mapper) {
        Assert.notNull(mapper, "convert function is null", new Object[0]);
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        if (Queues.isEmpty(queue)) {
            return q;
        }
        for (Object v : queue) {
            q.add(mapper.apply(v));
        }
        return q;
    }

    public static <E, V> Deque<E> map(Deque<V> queue, Function<V, E> f) {
        Assert.notNull(f, "convert function is null", new Object[0]);
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        if (Queues.isEmpty(queue)) {
            return q;
        }
        for (V v : queue) {
            q.add(f.apply(v));
        }
        return q;
    }

    public static <E> Queue<E> as(Iterator<E> iterator) {
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                q.add(iterator.next());
            }
        }
        return q;
    }

    public static <E> Deque<E> asd(Iterator<E> iterator) {
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                q.add(iterator.next());
            }
        }
        return q;
    }

    public static <E> Queue<E> as(Enumeration<E> iterator) {
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        if (iterator != null) {
            while (iterator.hasMoreElements()) {
                q.add(iterator.nextElement());
            }
        }
        return q;
    }

    public static <E> Deque<E> asd(Enumeration<E> iterator) {
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        if (iterator != null) {
            while (iterator.hasMoreElements()) {
                q.add(iterator.nextElement());
            }
        }
        return q;
    }
}

