/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.crypto.symmetric;

import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.crypto.enums.CipherAlgorithm;
import cn.orionsec.kit.lang.utils.crypto.enums.PaddingMode;
import cn.orionsec.kit.lang.utils.crypto.enums.WorkingMode;
import cn.orionsec.kit.lang.utils.crypto.symmetric.SymmetricCrypto;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public abstract class BaseSymmetric
implements SymmetricCrypto {
    protected CipherAlgorithm algorithm;
    protected WorkingMode workingMode;
    protected PaddingMode paddingMode;
    protected SecretKey secretKey;

    protected BaseSymmetric(CipherAlgorithm cipherAlgorithm, WorkingMode workingMode, PaddingMode paddingMode, SecretKey secretKey) {
        this.algorithm = Assert.notNull(cipherAlgorithm, "cipherAlgorithm is null", new Object[0]);
        this.workingMode = Assert.notNull(workingMode, "workingMode is null", new Object[0]);
        this.paddingMode = Assert.notNull(paddingMode, "paddingMode is null", new Object[0]);
        this.secretKey = Assert.notNull(secretKey, "secretKey is null", new Object[0]);
    }

    protected Cipher getCipher() {
        return this.algorithm.getCipher(this.workingMode, this.paddingMode);
    }

    protected byte[] clearZeroPadding(byte[] bytes) {
        if (!PaddingMode.ZERO_PADDING.equals((Object)this.paddingMode)) {
            return bytes;
        }
        int f = bytes.length;
        for (int i = 0; i < f; ++i) {
            if (bytes[i] != 0) continue;
            f = i;
            break;
        }
        if (f == bytes.length) {
            return bytes;
        }
        byte[] res = new byte[f];
        System.arraycopy(bytes, 0, res, 0, f);
        return res;
    }

    protected byte[] zeroPadding(byte[] bytes, int blockSize) {
        if (!PaddingMode.ZERO_PADDING.equals((Object)this.paddingMode)) {
            return bytes;
        }
        if (bytes.length % blockSize == 0) {
            return bytes;
        }
        int newSize = (bytes.length / blockSize + 1) * blockSize;
        byte[] res = new byte[newSize];
        System.arraycopy(bytes, 0, res, 0, bytes.length);
        return res;
    }

    public CipherAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public WorkingMode getWorkingMode() {
        return this.workingMode;
    }

    public PaddingMode getPaddingMode() {
        return this.paddingMode;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }
}

