/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.crypto.symmetric;

import cn.orionsec.kit.lang.utils.Strings;
import java.util.Arrays;

public interface SymmetricCrypto {
    public byte[] encrypt(byte[] var1);

    default public byte[] encrypt(String plain) {
        return this.encrypt(Strings.bytes(plain));
    }

    default public String encryptAsString(String plain) {
        return new String(this.encrypt(Strings.bytes(plain)));
    }

    default public String encryptAsString(byte[] plain) {
        return new String(this.encrypt(plain));
    }

    public byte[] decrypt(byte[] var1);

    default public byte[] decrypt(String text) {
        return this.decrypt(Strings.bytes(text));
    }

    default public String decryptAsString(String text) {
        return new String(this.decrypt(Strings.bytes(text)));
    }

    default public String decryptAsString(byte[] text) {
        return new String(this.decrypt(text));
    }

    default public boolean verify(String plain, String text) {
        try {
            return plain.equals(this.decryptAsString(text));
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean verify(byte[] plain, byte[] text) {
        try {
            return Arrays.equals(plain, this.decrypt(text));
        }
        catch (Exception e) {
            return false;
        }
    }
}

