/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ext.dom;

import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.ext.dom.DomNode;
import cn.orionsec.kit.lang.utils.ext.dom.DomSupport;
import cn.orionsec.kit.lang.utils.reflect.Classes;
import cn.orionsec.kit.lang.utils.reflect.Constructors;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomBeanWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomBeanWrapper.class);

    private DomBeanWrapper() {
    }

    public static <T> T toBean(Document document, Class<T> clazz) {
        return DomBeanWrapper.toBean(document.getRootElement(), clazz, null);
    }

    public static <T> T toBean(Document document, Class<T> clazz, Map<String, Object> convertMap) {
        return DomBeanWrapper.toBean(document.getRootElement(), clazz, convertMap);
    }

    public static <T> T toBean(Element element, Class<T> clazz) {
        return DomBeanWrapper.toBean(element, clazz, null);
    }

    public static <T> T toBean(Element element, Class<T> clazz, Map<String, Object> convertMapper) {
        Map<String, Object> paramValue;
        List<Class<?>> paramInter;
        Class paramsClass;
        Class<Object> paramType;
        Object getSetter;
        String elementSet;
        T t = Constructors.newInstance(clazz);
        List elements = element.elements();
        List<Method> setterMethod = Methods.getSetterMethods(clazz);
        LinkedHashMap<String, Integer> singleMap = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> multiMap = new LinkedHashMap<String, Integer>();
        for (Element element2 : elements) {
            List es = element2.elements();
            String eName = element2.getName();
            if (Lists.isEmpty(es)) {
                singleMap.merge(eName, 1, Integer::sum);
                continue;
            }
            multiMap.merge(eName, 1, Integer::sum);
        }
        for (Map.Entry entry : singleMap.entrySet()) {
            for (Method method : setterMethod) {
                elementSet = Methods.getSetterMethodNameByField((String)entry.getKey());
                if (convertMapper != null && (getSetter = convertMapper.get(entry.getKey())) instanceof String) {
                    elementSet = Methods.getSetterMethodNameByField(getSetter.toString());
                }
                if (!method.getName().equals(elementSet)) continue;
                paramType = method.getParameterTypes()[0];
                paramsClass = null;
                if (paramType.equals(Object.class)) {
                    if ((Integer)entry.getValue() == 1) {
                        paramType = String.class;
                        paramsClass = String.class;
                    } else {
                        paramType = ArrayList.class;
                        paramsClass = List.class;
                    }
                } else {
                    paramInter = Classes.getInterfaces(paramType);
                    for (Class<?> pi : paramInter) {
                        if (Set.class.getName().equals(pi.getName())) {
                            paramsClass = Set.class;
                            continue;
                        }
                        if (!List.class.getName().equals(pi.getName())) continue;
                        paramsClass = List.class;
                    }
                    if (paramsClass == null) {
                        paramsClass = paramType;
                    }
                }
                paramValue = null;
                if (paramsClass.equals(List.class) || paramsClass.equals(Set.class)) {
                    if (Classes.isInterface(paramType)) {
                        paramType = paramsClass.equals(List.class) ? ArrayList.class : Set.class;
                    }
                    Collection c = (Collection)Constructors.newInstance(paramType);
                    List list = element.elements((String)entry.getKey());
                    for (Element e : list) {
                        c.add(e.getStringValue());
                    }
                    paramValue = c;
                } else if (paramsClass.equals(String.class)) {
                    paramValue = element.element((String)entry.getKey()).getStringValue();
                }
                if (paramValue == null) {
                    try {
                        paramValue = element.element((String)entry.getKey()).getStringValue();
                    }
                    catch (Exception e) {
                        LOGGER.error("DomBeanWrapper.toBean get element error", (Throwable)e);
                    }
                }
                if (paramValue == null) continue;
                Methods.invokeMethodInfer(t, method.getName(), paramValue);
            }
        }
        for (Map.Entry entry : multiMap.entrySet()) {
            for (Method method : setterMethod) {
                Object childConvertMap;
                elementSet = Methods.getSetterMethodNameByField((String)entry.getKey());
                if (convertMapper != null && (getSetter = convertMapper.get(entry.getKey())) instanceof String) {
                    elementSet = Methods.getSetterMethodNameByField(getSetter.toString());
                }
                if (!method.getName().equals(elementSet)) continue;
                paramType = method.getParameterTypes()[0];
                paramsClass = null;
                if (paramType.equals(Object.class)) {
                    paramType = LinkedHashMap.class;
                    paramsClass = Map.class;
                } else {
                    paramInter = Classes.getInterfaces(paramType);
                    for (Class<?> pi : paramInter) {
                        if (!Map.class.getName().equals(pi.getName())) continue;
                        paramsClass = Map.class;
                    }
                    if (paramsClass == null) {
                        paramsClass = paramType;
                    }
                }
                paramValue = paramsClass.equals(Map.class) ? DomBeanWrapper.toMap(element.element((String)entry.getKey()), paramType) : (convertMapper != null ? ((childConvertMap = convertMapper.get(entry.getKey())) instanceof Map ? DomBeanWrapper.toBean(element.element((String)entry.getKey()), paramType, (Map<String, Object>)((Map)childConvertMap)) : DomBeanWrapper.toBean(element.element((String)entry.getKey()), paramType, null)) : DomBeanWrapper.toBean(element.element((String)entry.getKey()), paramType, null));
                Methods.invokeMethodInfer(t, method.getName(), paramValue);
            }
        }
        return t;
    }

    public static Map<String, Object> toMap(Document document) {
        return DomBeanWrapper.toMap(document.getRootElement(), LinkedHashMap.class);
    }

    public static Map<String, Object> toMap(Element element) {
        return DomBeanWrapper.toMap(element, LinkedHashMap.class);
    }

    public static Map<String, Object> toMap(Element element, Class<?> mapClass) {
        Map map = mapClass == null || mapClass.equals(Map.class) ? new LinkedHashMap() : (Map)Constructors.newInstance(mapClass);
        LinkedHashMap<String, Integer> countMap = new LinkedHashMap<String, Integer>();
        List elements = element.elements();
        for (Element element2 : elements) {
            countMap.merge(element2.getName(), 1, Integer::sum);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() == 1) {
                Element child = element.element((String)entry.getKey());
                if (!Lists.isEmpty(child.elements())) {
                    map.put(entry.getKey(), DomBeanWrapper.toMap(child));
                    continue;
                }
                map.put(entry.getKey(), (Object)child.getStringValue());
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            List childList = element.elements((String)entry.getKey());
            for (Element child : childList) {
                if (!Lists.isEmpty(child.elements())) {
                    list.add(DomBeanWrapper.toMap(child));
                    continue;
                }
                list.add(child.getStringValue());
            }
            map.put(entry.getKey(), list);
        }
        return map;
    }

    public static Map<String, DomNode> toDomNode(Document document) {
        return DomBeanWrapper.toDomNode(document.getRootElement());
    }

    public static Map<String, DomNode> toDomNode(Element element) {
        LinkedHashMap<String, DomNode> map = new LinkedHashMap<String, DomNode>();
        LinkedHashMap<String, Integer> countMap = new LinkedHashMap<String, Integer>();
        List elements = element.elements();
        for (Element element2 : elements) {
            countMap.merge(element2.getName(), 1, Integer::sum);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() == 1) {
                Element child = element.element((String)entry.getKey());
                if (!Lists.isEmpty(child.elements())) {
                    map.put((String)entry.getKey(), new DomNode(DomBeanWrapper.toDomNode(child)).setAttr(DomSupport.getAttributes(child)));
                    continue;
                }
                map.put((String)entry.getKey(), new DomNode(child.getStringValue()).setAttr(DomSupport.getAttributes(child)));
                continue;
            }
            ArrayList<DomNode> list = new ArrayList<DomNode>();
            List childList = element.elements((String)entry.getKey());
            for (Element child : childList) {
                if (!Lists.isEmpty(child.elements())) {
                    list.add(new DomNode(DomBeanWrapper.toDomNode(child)).setAttr(DomSupport.getAttributes(child)));
                    continue;
                }
                list.add(new DomNode(child.getStringValue()).setAttr(DomSupport.getAttributes(child)));
            }
            map.put((String)entry.getKey(), new DomNode(list));
        }
        return map;
    }
}

