/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ext.dom;

import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.ext.dom.DomSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class DomStream {
    private Element element;

    public DomStream(String xml) {
        this(DomSupport.toElement(xml));
    }

    public DomStream(Document document) {
        Assert.notNull(document, "the document is null", new Object[0]);
        this.element = document.getRootElement();
    }

    public DomStream(Element element) {
        Assert.notNull(element, "the element is null", new Object[0]);
        this.element = element;
    }

    public static DomStream of(String xml) {
        return new DomStream(xml);
    }

    public static DomStream of(Element element) {
        return new DomStream(element);
    }

    public DomStream childFirst() {
        List elements = this.element.elements();
        if (elements != null && elements.size() >= 1) {
            this.element = (Element)elements.get(0);
            return this;
        }
        throw Exceptions.argument("not found child element");
    }

    public DomStream childLast() {
        List elements = this.element.elements();
        if (elements != null && elements.size() >= 1) {
            this.element = (Element)elements.get(elements.size() - 1);
            return this;
        }
        throw Exceptions.argument("not found child element");
    }

    public DomStream childFirst(String tag) {
        Element element = this.element.element(tag);
        if (element != null) {
            this.element = element;
            return this;
        }
        throw Exceptions.argument(Strings.format("not found child element tag: {}", tag));
    }

    public DomStream childLast(String tag) {
        List elements = this.element.elements(tag);
        if (elements.size() >= 1) {
            this.element = (Element)elements.get(elements.size() - 1);
            return this;
        }
        throw Exceptions.argument(Strings.format("not found child element tag: {}", tag));
    }

    public DomStream child() {
        return this.child(0);
    }

    public DomStream child(int index) {
        List elements = this.element.elements();
        if (elements != null && elements.size() > index) {
            this.element = (Element)elements.get(index);
            return this;
        }
        throw Exceptions.argument(Strings.format("not found child element index: {}", index));
    }

    public DomStream child(String tag) {
        Element element = this.element.element(tag);
        if (element != null) {
            this.element = element;
            return this;
        }
        throw Exceptions.argument(Strings.format("not found child element tag: {}", tag));
    }

    public DomStream child(String tag, int index) {
        List elements = this.element.elements(tag);
        if (elements != null && elements.size() > index) {
            this.element = (Element)elements.get(index);
            return this;
        }
        throw Exceptions.argument(Strings.format("not found child element tag: {}, index: {}", tag, index));
    }

    public DomStream child(String tag, String attrKey) {
        return this.child(tag, 0, attrKey, null);
    }

    public DomStream child(String tag, String attrKey, String attrValue) {
        return this.child(tag, 0, attrKey, attrValue);
    }

    public DomStream child(String tag, int index, String attrKey) {
        return this.child(tag, index, attrKey, null);
    }

    public DomStream child(String tag, int index, String attrKey, String attrValue) {
        List elements = this.element.elements(tag);
        int i = 0;
        for (Element element : elements) {
            String attribute = DomSupport.getAttribute(element, attrKey);
            if (attribute == null) continue;
            if (attrValue == null) {
                if (i++ != index) continue;
                this.element = element;
                return this;
            }
            if (!attrValue.trim().equals(attribute.trim()) || i++ != index) continue;
            this.element = element;
            return this;
        }
        if (attrValue == null) {
            throw Exceptions.argument(Strings.format("not found child element tag: {}, key: {}, index: {}", tag, attrKey, index));
        }
        throw Exceptions.argument(Strings.format("not found child element tag: {}, key: {}, value: {}, index: {}", tag, attrKey, attrValue, index));
    }

    public DomStream parentFirst() {
        Element parent = this.element.getParent();
        while (parent != null) {
            Element p = parent.getParent();
            if (p == null) {
                this.element = parent;
                return this;
            }
            parent = p;
        }
        return this;
    }

    public DomStream parent() {
        Element parent = this.element.getParent();
        if (parent != null) {
            this.element = parent;
            return this;
        }
        throw Exceptions.argument("not found parent element");
    }

    public DomStream parent(int index) {
        if (index < 0) {
            throw Exceptions.argument("not found parent element index: {}" + index);
        }
        for (int i = 0; i < index + 1; ++i) {
            Element parent = this.element.getParent();
            if (parent == null) {
                throw Exceptions.argument(Strings.format("not found parent element index: {}", i));
            }
            this.element = parent;
        }
        return this;
    }

    public DomStream parent(String tag) {
        return this.parent(tag, 0);
    }

    public DomStream parent(String tag, int index) {
        if (tag == null) {
            throw Exceptions.argument("not found parent element because tag is null");
        }
        int i = 0;
        Element parent = this.element.getParent();
        while (parent != null) {
            if (parent.getName().trim().equals(tag.trim())) {
                if (i++ == index) {
                    this.element = parent;
                    return this;
                }
                parent = parent.getParent();
                continue;
            }
            parent = parent.getParent();
        }
        throw Exceptions.argument(Strings.format("not found parent element tag: {}, index: {}", tag, index));
    }

    public DomStream parent(String tag, String attrKey) {
        return this.parent(tag, 0, attrKey, null);
    }

    public DomStream parent(String tag, String attrKey, String attrValue) {
        return this.parent(tag, 0, attrKey, attrValue);
    }

    public DomStream parent(String tag, int index, String attrKey) {
        return this.parent(tag, index, attrKey, null);
    }

    public DomStream parent(String tag, int index, String attrKey, String attrValue) {
        if (tag == null) {
            throw Exceptions.argument("not found parent element because tag is null");
        }
        int i = 0;
        for (Element parent = this.element.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getName().trim().equals(tag.trim())) continue;
            if (attrKey != null) {
                String attribute = DomSupport.getAttribute(parent, attrKey);
                if (attribute == null) continue;
                if (attrValue == null) {
                    if (i++ != index) continue;
                    this.element = parent;
                    return this;
                }
                if (!attribute.trim().equals(attrValue.trim()) || i++ != index) continue;
                this.element = parent;
                return this;
            }
            this.element = parent;
            return this;
        }
        throw Exceptions.argument(Strings.format("not found parent element tag: {}, key: {}, value: {}, index: {}", tag, attrKey, attrValue, index));
    }

    public DomStream nextLast() {
        Element parent = this.element.getParent();
        List elements = parent.elements();
        this.element = (Element)elements.get(elements.size() - 1);
        return this;
    }

    public DomStream next() {
        return this.next(0);
    }

    public DomStream next(int index) {
        int nextIndex;
        if (index < 0) {
            throw Exceptions.argument(Strings.format("not found next element index: {}", index));
        }
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        if (len == 1) {
            throw Exceptions.argument("not found next element");
        }
        if (len < index + 1) {
            throw Exceptions.argument(Strings.format("not found next element index: {}", index));
        }
        int thisIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (!((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
            break;
        }
        if (len <= (nextIndex = thisIndex + index + 1)) {
            throw Exceptions.argument(Strings.format("not found next element index: {}, thisIndex: {}, nextIndex: {}, count: {}", index, thisIndex, nextIndex, len));
        }
        this.element = (Element)elements.get(nextIndex);
        return this;
    }

    public DomStream next(String tag) {
        return this.next(tag, 0);
    }

    public DomStream next(String tag, int index) {
        if (tag == null) {
            throw Exceptions.argument("not found next element because tag is null");
        }
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        if (len == 1) {
            throw Exceptions.argument("not found next element");
        }
        if (len < index + 1) {
            throw Exceptions.argument(Strings.format("not found next element tag: {}, index: {}", tag, index));
        }
        int thisIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (!((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
            break;
        }
        int is = 0;
        for (int i = thisIndex + 1; i < len; ++i) {
            Element nowElement = (Element)elements.get(i);
            if (!nowElement.getName().trim().equals(tag.trim()) || is++ != index) continue;
            this.element = nowElement;
            return this;
        }
        throw Exceptions.argument(Strings.format("not found next element tag: {}, index: {}", tag, index));
    }

    public DomStream next(String tag, String attrKey) {
        return this.next(tag, 0, attrKey, null);
    }

    public DomStream next(String tag, String attrKey, String attrValue) {
        return this.next(tag, 0, attrKey, attrValue);
    }

    public DomStream next(String tag, int index, String attrKey) {
        return this.next(tag, index, attrKey, null);
    }

    public DomStream next(String tag, int index, String attrKey, String attrValue) {
        if (tag == null) {
            throw Exceptions.argument("not found next element because tag is null");
        }
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        if (len == 1) {
            throw Exceptions.argument("not found next element");
        }
        if (len < index + 1) {
            throw Exceptions.argument(Strings.format("not found next element tag: {}, index: {}, key: {}, value: {}", tag, index, attrKey, attrValue));
        }
        int thisIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (!((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
            break;
        }
        int is = 0;
        for (int i = thisIndex + 1; i < len; ++i) {
            Element nowElement = (Element)elements.get(i);
            if (!nowElement.getName().trim().equals(tag.trim())) continue;
            if (attrKey != null) {
                String attribute = DomSupport.getAttribute(nowElement, attrKey);
                if (attribute == null) continue;
                if (attrValue == null) {
                    if (is++ != index) continue;
                    this.element = nowElement;
                    return this;
                }
                if (!attribute.trim().equals(attrValue.trim()) || is++ != index) continue;
                this.element = nowElement;
                return this;
            }
            if (is++ != index) continue;
            this.element = nowElement;
            return this;
        }
        throw Exceptions.argument(Strings.format("not found next element tag: {}, index: {}, key: {}, value: {}", tag, index, attrKey, attrValue));
    }

    public DomStream prevFirst() {
        Element parent = this.element.getParent();
        List elements = parent.elements();
        this.element = (Element)elements.get(0);
        return this;
    }

    public DomStream prev() {
        return this.prev(0);
    }

    public DomStream prev(int index) {
        int prevIndex;
        if (index < 0) {
            throw Exceptions.argument(Strings.format("not found previous element index: {}", index));
        }
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        if (len == 1) {
            throw Exceptions.argument("not found previous element");
        }
        if (len < index + 1) {
            throw Exceptions.argument(Strings.format("not found previous element index: {}", index));
        }
        int thisIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (!((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
            break;
        }
        if (len <= (prevIndex = thisIndex - index - 1) || prevIndex < 0) {
            throw Exceptions.argument(Strings.format("not found previous element index: {}, thisIndex: {}, prevIndex: {}, count: {}", index, thisIndex, prevIndex, len));
        }
        this.element = (Element)elements.get(prevIndex);
        return this;
    }

    public DomStream prev(String tag) {
        return this.prev(tag, 0);
    }

    public DomStream prev(String tag, int index) {
        if (index < 0) {
            throw Exceptions.argument(Strings.format("not found previous element index: {}", index));
        }
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        if (len == 1) {
            throw Exceptions.argument("not found previous element");
        }
        if (len < index + 1) {
            throw Exceptions.argument(Strings.format("not found previous element index: {}", index));
        }
        int thisIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (!((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
            break;
        }
        int is = 0;
        for (int i = thisIndex - 1; i >= 0; --i) {
            Element nowElement = (Element)elements.get(i);
            if (!nowElement.getName().trim().equals(tag.trim()) || is++ != index) continue;
            this.element = nowElement;
            return this;
        }
        throw Exceptions.argument(Strings.format("not found previous element tag: {}, index: {}", tag, index));
    }

    public DomStream prev(String tag, String attrKey) {
        return this.prev(tag, 0, attrKey, null);
    }

    public DomStream prev(String tag, String attrKey, String attrValue) {
        return this.prev(tag, 0, attrKey, attrValue);
    }

    public DomStream prev(String tag, int index, String attrKey) {
        return this.prev(tag, index, attrKey, null);
    }

    public DomStream prev(String tag, int index, String attrKey, String attrValue) {
        if (tag == null) {
            throw Exceptions.argument("not found previous element because tag is null");
        }
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        if (len == 1) {
            throw Exceptions.argument("not found previous element");
        }
        if (len < index + 1) {
            throw Exceptions.argument(Strings.format("not found previous element tag: {}, index: {}, key: {}, value: {}", tag, index, attrKey, attrValue));
        }
        int thisIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (!((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
            break;
        }
        int is = 0;
        for (int i = thisIndex - 1; i >= 0; --i) {
            Element nowElement = (Element)elements.get(i);
            if (!nowElement.getName().trim().equals(tag.trim())) continue;
            if (attrKey != null) {
                String attribute = DomSupport.getAttribute(nowElement, attrKey);
                if (attribute == null) continue;
                if (attrValue == null) {
                    if (is++ != index) continue;
                    this.element = nowElement;
                    return this;
                }
                if (!attribute.trim().equals(attrValue.trim()) || is++ != index) continue;
                this.element = nowElement;
                return this;
            }
            if (is++ != index) continue;
            this.element = nowElement;
            return this;
        }
        throw Exceptions.argument(Strings.format("not found previous element tag: {}, index: {}, key: {}, value: {}", tag, index, attrKey, attrValue));
    }

    public List<Element> childs() {
        List elements = this.element.elements();
        if (elements != null) {
            return elements;
        }
        return new ArrayList<Element>();
    }

    public List<Element> childs(String tag) {
        List elements = this.element.elements(tag);
        if (elements != null) {
            return elements;
        }
        return new ArrayList<Element>();
    }

    public int childCount() {
        return Lists.size(this.element.elements());
    }

    public int childCount(String tag) {
        return Lists.size(this.element.elements(tag));
    }

    public List<Element> parents() {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element parent = this.element.getParent(); parent != null; parent = parent.getParent()) {
            list.add(parent);
        }
        return list;
    }

    public List<Element> parents(String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element parent = this.element.getParent(); parent != null; parent = parent.getParent()) {
            if (tag == null || !parent.getName().trim().equals(tag.trim())) continue;
            list.add(parent);
        }
        return list;
    }

    public int parentCount() {
        return this.parents().size();
    }

    public int parentCount(String tag) {
        return this.parents(tag).size();
    }

    public List<Element> nexts() {
        ArrayList<Element> list = new ArrayList<Element>();
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        int thisIndex = -1;
        for (int i = 0; i < len; ++i) {
            if (thisIndex == -1) {
                if (!((Element)elements.get(i)).equals(this.element)) continue;
                thisIndex = i;
                continue;
            }
            list.add((Element)elements.get(i));
        }
        return list;
    }

    public List<Element> nexts(String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        int thisIndex = -1;
        for (int i = 0; i < len; ++i) {
            if (thisIndex == -1) {
                if (!((Element)elements.get(i)).equals(this.element)) continue;
                thisIndex = i;
                continue;
            }
            Element thisElement = (Element)elements.get(i);
            if (tag == null) {
                list.add(thisElement);
                continue;
            }
            if (!thisElement.getName().trim().equals(tag.trim())) continue;
            list.add(thisElement);
        }
        return list;
    }

    public int nextCount() {
        return this.nexts().size();
    }

    public int nextCount(String tag) {
        return this.nexts(tag).size();
    }

    public List<Element> prevs() {
        int i;
        ArrayList<Element> list = new ArrayList<Element>();
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int thisIndex = -1;
        int len = elements.size();
        for (i = 0; i < len; ++i) {
            if (thisIndex != -1 || !((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
        }
        for (i = thisIndex - 1; i >= 0; --i) {
            list.add((Element)elements.get(i));
        }
        return list;
    }

    public List<Element> prevs(String tag) {
        int i;
        ArrayList<Element> list = new ArrayList<Element>();
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int thisIndex = -1;
        int len = elements.size();
        for (i = 0; i < len; ++i) {
            if (thisIndex != -1 || !((Element)elements.get(i)).equals(this.element)) continue;
            thisIndex = i;
        }
        for (i = thisIndex - 1; i >= 0; --i) {
            Element thisElement = (Element)elements.get(i);
            if (tag == null) {
                list.add(thisElement);
                continue;
            }
            if (!thisElement.getName().trim().equals(tag.trim())) continue;
            list.add(thisElement);
        }
        return list;
    }

    public int prevCount() {
        return this.prevs().size();
    }

    public int prevCount(String tag) {
        return this.prevs(tag).size();
    }

    public int getThisElementIndex() {
        Element parent = this.element.getParent();
        List elements = parent.elements();
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            if (!((Element)elements.get(i)).equals(this.element)) continue;
            return i;
        }
        return 0;
    }

    public Element getElement() {
        return this.element;
    }

    public String getAttribute(String key) {
        return DomSupport.getAttribute(this.element, key);
    }

    public Map<String, String> getAttributes() {
        return DomSupport.getAttributes(this.element);
    }

    public String getValue() {
        return this.element.getStringValue();
    }
}

