/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.identity;

import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.regexp.Matches;
import cn.orionsec.kit.lang.utils.regexp.Patterns;
import cn.orionsec.kit.lang.utils.time.Birthdays;
import cn.orionsec.kit.lang.utils.time.DateStream;
import cn.orionsec.kit.lang.utils.time.Dates;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class IdCards {
    private static final int CHINA_ID_LENGTH = 18;
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final Map<String, String> CITY_CODES = new HashMap<String, String>();

    private IdCards() {
    }

    public static boolean isValidCard(String idCard) {
        if (18 != idCard.length()) {
            return false;
        }
        String proCode = idCard.substring(0, 2);
        if (CITY_CODES.get(proCode) == null) {
            return false;
        }
        Date birthDay = Dates.parse(idCard.substring(6, 14), "yyyyMMdd");
        if (birthDay == null) {
            return false;
        }
        DateStream bs = Dates.stream(birthDay);
        if (!Birthdays.isBirthdayNotFuture(bs.getYear(), bs.getMonth(), bs.getDay())) {
            return false;
        }
        String code17 = idCard.substring(0, 17);
        char code18 = Character.toLowerCase(idCard.charAt(17));
        if (Matches.test(code17, Patterns.INTEGER)) {
            return IdCards.getCheckCode18(code17) == code18;
        }
        return false;
    }

    public static int getAge(String idCard) {
        return IdCards.getAge(idCard, new Date());
    }

    public static int getAge(String idCard, Date range) {
        String birth = IdCards.getBirth(idCard);
        return Birthdays.getAge(Dates.parse(birth, "yyyyMMdd"), range);
    }

    public static String getBirth(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return Objects.requireNonNull(idCard).substring(6, 14);
    }

    public static int getYear(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return Integer.parseInt(Objects.requireNonNull(idCard).substring(6, 10));
    }

    public static int getMonth(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return Integer.parseInt(Objects.requireNonNull(idCard).substring(10, 12));
    }

    public static int getDay(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return Integer.parseInt(Objects.requireNonNull(idCard).substring(12, 14));
    }

    public static boolean getGender(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return idCard.charAt(16) % 2 == 1;
    }

    public static String getProvince(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return CITY_CODES.get(idCard.substring(0, 2));
    }

    public static Integer getProvinceCode(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return Integer.valueOf(idCard.substring(0, 2));
    }

    public static Integer getCityCode(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return Integer.valueOf(idCard.substring(0, 4));
    }

    public static Integer getCountryCode(String idCard) {
        Assert.validLength(idCard, 18, "ID Card length must be 18", new Object[0]);
        return Integer.valueOf(idCard.substring(0, 6));
    }

    public static int getPowerSum(char[] arr) {
        int sum = 0;
        if (POWER.length == arr.length) {
            for (int i = 0; i < arr.length; ++i) {
                sum += Integer.parseInt(String.valueOf(arr[i])) * POWER[i];
            }
        }
        return sum;
    }

    public static char getCheckCode18(int sum) {
        switch (sum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'x';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    public static char getCheckCode18(String code17) {
        return IdCards.getCheckCode18(IdCards.getPowerSum(code17.toCharArray()));
    }

    static {
        CITY_CODES.put("11", "\u5317\u4eac");
        CITY_CODES.put("12", "\u5929\u6d25");
        CITY_CODES.put("13", "\u6cb3\u5317");
        CITY_CODES.put("14", "\u5c71\u897f");
        CITY_CODES.put("15", "\u5185\u8499\u53e4");
        CITY_CODES.put("21", "\u8fbd\u5b81");
        CITY_CODES.put("22", "\u5409\u6797");
        CITY_CODES.put("23", "\u9ed1\u9f99\u6c5f");
        CITY_CODES.put("31", "\u4e0a\u6d77");
        CITY_CODES.put("32", "\u6c5f\u82cf");
        CITY_CODES.put("33", "\u6d59\u6c5f");
        CITY_CODES.put("34", "\u5b89\u5fbd");
        CITY_CODES.put("35", "\u798f\u5efa");
        CITY_CODES.put("36", "\u6c5f\u897f");
        CITY_CODES.put("37", "\u5c71\u4e1c");
        CITY_CODES.put("41", "\u6cb3\u5357");
        CITY_CODES.put("42", "\u6e56\u5317");
        CITY_CODES.put("43", "\u6e56\u5357");
        CITY_CODES.put("44", "\u5e7f\u4e1c");
        CITY_CODES.put("45", "\u5e7f\u897f");
        CITY_CODES.put("46", "\u6d77\u5357");
        CITY_CODES.put("50", "\u91cd\u5e86");
        CITY_CODES.put("51", "\u56db\u5ddd");
        CITY_CODES.put("52", "\u8d35\u5dde");
        CITY_CODES.put("53", "\u4e91\u5357");
        CITY_CODES.put("54", "\u897f\u85cf");
        CITY_CODES.put("61", "\u9655\u897f");
        CITY_CODES.put("62", "\u7518\u8083");
        CITY_CODES.put("63", "\u9752\u6d77");
        CITY_CODES.put("64", "\u5b81\u590f");
        CITY_CODES.put("65", "\u65b0\u7586");
        CITY_CODES.put("71", "\u53f0\u6e7e");
        CITY_CODES.put("81", "\u9999\u6e2f");
        CITY_CODES.put("82", "\u6fb3\u95e8");
        CITY_CODES.put("91", "\u56fd\u5916");
    }
}

