/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class FileEncodes {
    private FileEncodes() {
    }

    public static String getEncoding(String file) {
        return FileEncodes.getEncoding(new File(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getEncoding(File file) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try (BufferedInputStream bis = new BufferedInputStream(Files1.openInputStream(file));){
            int read;
            block28: {
                boolean checked = false;
                bis.mark(0);
                read = bis.read(first3Bytes, 0, 3);
                if (read == -1) {
                    bis.close();
                    String string = charset;
                    return string;
                }
                if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                    charset = "UTF-16LE";
                    checked = true;
                } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                    charset = "UTF-16BE";
                    checked = true;
                } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                    charset = "UTF-8";
                    checked = true;
                }
                bis.reset();
                if (checked) return charset;
                while ((read = bis.read()) != -1) {
                    if (read >= 240) {
                        return charset;
                    }
                    if (128 <= read && read <= 191) {
                        return charset;
                    }
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read) return charset;
                        if (read <= 191) continue;
                        return charset;
                    }
                    if (224 > read) {
                        continue;
                    }
                    break block28;
                }
                return charset;
            }
            read = bis.read();
            if (128 > read) return charset;
            if (read > 191) return charset;
            read = bis.read();
            if (128 > read) return charset;
            if (read > 191) return charset;
            charset = "UTF-8";
            return charset;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void convertEncoding(String file, String fromCharset, String toCharset) {
        FileEncodes.convertEncoding(new File(file), fromCharset, toCharset);
    }

    public static void convertEncoding(File file, String fromCharset, String toCharset) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)Files1.openInputStream(file), fromCharset);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)Files1.openOutputStream(file), toCharset);){
            Streams.transfer((Reader)reader, (Writer)writer);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }
}

