/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io;

import cn.orionsec.kit.lang.able.ILock;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class FileLocks {
    private FileLocks() {
    }

    public static ChannelFileLock getChannelFileLock(String file) {
        return new ChannelFileLock(file);
    }

    public static ChannelFileLock getChannelFileLock(File file) {
        return new ChannelFileLock(file);
    }

    public static ChannelFileLock getChannelFileLock(Path file) {
        return new ChannelFileLock(file);
    }

    public static NamedFileLock getPrefixFileLock(String file) {
        return new NamedFileLock(file).suffix("");
    }

    public static NamedFileLock getPrefixFileLock(File file) {
        return new NamedFileLock(file).suffix("");
    }

    public static NamedFileLock getPrefixFileLock(String lockPrefix, String file) {
        return new NamedFileLock(file).prefix(lockPrefix).suffix("");
    }

    public static NamedFileLock getPrefixFileLock(String lockPrefix, File file) {
        return new NamedFileLock(file).prefix(lockPrefix).suffix("");
    }

    public static NamedFileLock getSuffixFileLock(String file) {
        return new NamedFileLock(file).prefix("");
    }

    public static NamedFileLock getSuffixFileLock(File file) {
        return new NamedFileLock(file).prefix("");
    }

    public static NamedFileLock getSuffixFileLock(String lockSuffix, String file) {
        return new NamedFileLock(file).prefix("").suffix(lockSuffix);
    }

    public static NamedFileLock getSuffixFileLock(String lockSuffix, File file) {
        return new NamedFileLock(file).prefix("").suffix(lockSuffix);
    }

    public static NamedFileLock getNamedFileLock(String file) {
        return new NamedFileLock(file);
    }

    public static NamedFileLock getNamedFileLock(File file) {
        return new NamedFileLock(file);
    }

    public static NamedFileLock getNamedFileLock(String lockPrefix, String lockSuffix, String file) {
        return new NamedFileLock(file).prefix(lockPrefix).suffix(lockSuffix);
    }

    public static NamedFileLock getNamedFileLock(String lockPrefix, String lockSuffix, File file) {
        return new NamedFileLock(file).prefix(lockPrefix).suffix(lockSuffix);
    }

    public static class NamedFileLock
    implements ILock {
        private String prefix;
        private String suffix;
        private File file;
        private File lockFile;

        private NamedFileLock(String file) {
            this(new File(file));
        }

        private NamedFileLock(File file) {
            this.file = file;
            this.prefix = "~";
            this.suffix = ".lock";
        }

        public NamedFileLock prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public NamedFileLock suffix(String suffix) {
            this.suffix = "." + suffix;
            return this;
        }

        @Override
        public boolean tryLock() {
            this.init();
            if (!this.file.exists()) {
                throw Exceptions.ioRuntime("file not found error: " + this.file.getAbsolutePath());
            }
            if (this.lockFile.exists()) {
                return true;
            }
            try {
                Files1.mkdirs(this.lockFile.getParentFile());
                return this.lockFile.createNewFile();
            }
            catch (Exception e) {
                throw Exceptions.ioRuntime("create lock file error: " + this.file.getAbsolutePath(), e);
            }
        }

        @Override
        public void unLock() {
            this.init();
            if (this.lockFile.exists() && this.lockFile.isFile()) {
                Files1.deleteFile(this.lockFile);
            }
        }

        @Override
        public boolean isLocked() {
            this.init();
            return this.lockFile.exists();
        }

        private void init() {
            if (this.lockFile == null) {
                this.lockFile = new File(this.file.getParent() + "/" + this.prefix + this.file.getName() + this.suffix);
            }
        }
    }

    public static class ChannelFileLock
    implements ILock {
        private Path file;
        private FileChannel channel;
        private FileLock lock;

        private ChannelFileLock(String file) {
            this.file = Paths.get(file, new String[0]);
        }

        private ChannelFileLock(File file) {
            this.file = Paths.get(file.getAbsolutePath(), new String[0]);
        }

        private ChannelFileLock(Path file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock() {
            boolean success = false;
            try {
                if (this.channel != null && this.channel.isOpen()) {
                    boolean bl = false;
                    return bl;
                }
                this.channel = FileChannel.open(this.file, StandardOpenOption.WRITE, StandardOpenOption.READ);
                this.lock = this.channel.tryLock();
                if (this.lock != null) {
                    success = true;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (!success) {
                    Streams.close(this.channel);
                }
            }
            return false;
        }

        @Override
        public void unLock() {
            try {
                if (this.lock != null) {
                    this.lock.release();
                }
            }
            catch (IOException e) {
                throw Exceptions.ioRuntime(e);
            }
            finally {
                Streams.close(this.channel);
            }
        }

        @Override
        public boolean isLocked() {
            if (this.lock == null) {
                return false;
            }
            return this.lock.isValid();
        }
    }
}

