/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress;

import cn.orionsec.kit.lang.id.ObjectIds;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Systems;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.io.compress.FileCompressor;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class BaseFileCompressor
implements FileCompressor {
    protected Map<String, File> compressFiles = new LinkedHashMap<String, File>();
    protected Map<String, InputStream> compressStreams = new LinkedHashMap<String, InputStream>();
    protected String suffix;
    private String compressPath = Systems.TEMP_DIR;
    private String fileName = ObjectIds.nextId();
    private String absoluteCompressPath;
    private Consumer<String> notify;

    public BaseFileCompressor(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void addFile(String file) {
        Assert.notBlank(file, "file is null", new Object[0]);
        this.addFile(new File(file));
    }

    @Override
    public void addFile(File file) {
        Assert.notNull(file, "file is null", new Object[0]);
        if (!file.exists()) {
            throw Exceptions.notFound(file + " compress file not found");
        }
        if (file.isDirectory()) {
            int len = Files1.getPath(file.getParent()).length();
            List<File> files = Files1.listFiles(file, true);
            for (File dirFile : files) {
                this.compressFiles.put(Files1.getPath(dirFile.getAbsolutePath()).substring(len + 1), dirFile);
            }
        } else {
            this.compressFiles.put(file.getName(), file);
        }
    }

    @Override
    public void addFile(String name, String file) {
        Assert.notBlank(file, "file is null", new Object[0]);
        this.addFile(name, new File(file));
    }

    @Override
    public void addFile(String name, File file) {
        Assert.notBlank(name, "name is null", new Object[0]);
        Assert.notNull(file, "file is null", new Object[0]);
        if (!file.exists()) {
            throw Exceptions.notFound(file + " compress file not found");
        }
        if (file.isDirectory()) {
            throw Exceptions.unsupported("set name unsupported add directory");
        }
        this.compressFiles.put(name, file);
    }

    @Override
    public void addFilePrefix(String prefix, String file) {
        Assert.notNull(file, "file is null", new Object[0]);
        this.addFilePrefix(prefix, new File(file));
    }

    @Override
    public void addFilePrefix(String prefix, File file) {
        Assert.notBlank(prefix, "prefix is null", new Object[0]);
        Assert.notNull(file, "file is null", new Object[0]);
        if (!file.exists()) {
            throw Exceptions.notFound(file + " compress file not found");
        }
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (file.isDirectory()) {
            int len = Files1.getPath(file.getParent()).length();
            List<File> files = Files1.listFiles(file, true);
            for (File dirFile : files) {
                this.compressFiles.put(prefix + Files1.getPath(dirFile.getAbsolutePath()).substring(len + 1), dirFile);
            }
        } else {
            this.compressFiles.put(prefix + file.getName(), file);
        }
    }

    @Override
    public void addFile(String name, byte[] bs) {
        Assert.notBlank(name, "name is null", new Object[0]);
        Assert.notNull(bs, "byte array is null", new Object[0]);
        this.compressStreams.put(name, Streams.toInputStream(bs));
    }

    @Override
    public void addFile(String name, InputStream in) {
        Assert.notBlank(name, "name is null", new Object[0]);
        Assert.notNull(in, "input stream is null", new Object[0]);
        this.compressStreams.put(name, in);
    }

    @Override
    public void compressNotify(Consumer<String> notify) {
        this.notify = notify;
    }

    @Override
    public void compress() throws Exception {
        Assert.isFalse(this.compressFiles.isEmpty() && this.compressStreams.isEmpty(), "compress entities is empty", new Object[0]);
        this.doCompress();
    }

    protected abstract void doCompress() throws Exception;

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void setCompressPath(String compressPath) {
        this.compressPath = compressPath;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void setAbsoluteCompressPath(String path) {
        this.absoluteCompressPath = path;
    }

    @Override
    public String getAbsoluteCompressPath() {
        if (this.absoluteCompressPath != null) {
            return this.absoluteCompressPath;
        }
        return Files1.getPath(this.compressPath, this.fileName + "." + this.suffix);
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    protected void unsupportedOperation() {
        throw Exceptions.unsupported("compress file not support operation");
    }

    protected void notify(String name) {
        if (this.notify != null) {
            this.notify.accept(name);
        }
    }
}

