/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress;

import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.compress.FileDecompressor;
import java.io.File;

public abstract class BaseFileDecompressor
implements FileDecompressor {
    protected File decompressFile;
    protected File decompressTargetPath;
    protected String suffix;

    public BaseFileDecompressor(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void setDecompressFile(String decompressFile) {
        this.setDecompressFile(new File(decompressFile));
    }

    @Override
    public void setDecompressFile(File decompressFile) {
        this.decompressFile = decompressFile;
    }

    @Override
    public void setDecompressTargetPath(String decompressTargetPath) {
        this.setDecompressTargetPath(new File(decompressTargetPath));
    }

    @Override
    public void setDecompressTargetPath(File decompressPath) {
        this.decompressTargetPath = decompressPath;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void decompress() throws Exception {
        Assert.notNull(this.decompressFile, "decompress file is null", new Object[0]);
        Assert.notNull(this.decompressTargetPath, "decompress target path is null", new Object[0]);
        Assert.isTrue(Files1.isFile(this.decompressFile), "decompress file is not a file", new Object[0]);
        this.doDecompress();
    }

    protected abstract void doDecompress() throws Exception;

    @Override
    public File getDecompressFile() {
        return this.decompressFile;
    }

    @Override
    public File getDecompressTargetPath() {
        return this.decompressTargetPath;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

