/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress.bz2;

import cn.orionsec.kit.lang.id.ObjectIds;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.io.compress.BaseFileDecompressor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class Bz2Decompressor
extends BaseFileDecompressor {
    private BZip2CompressorInputStream inputStream;
    private InputStream decompressInputStream;
    private OutputStream decompressTargetOutputStream;
    private String decompressTargetFileName;
    private File decompressTargetFile;

    public Bz2Decompressor() {
        this("bz2");
    }

    public Bz2Decompressor(String suffix) {
        super(suffix);
    }

    @Override
    public void decompress() throws Exception {
        if (this.decompressFile != null) {
            Assert.isTrue(Files1.isFile(this.decompressFile), "decompress file is not a file", new Object[0]);
        } else {
            Assert.notNull(this.decompressInputStream, "decompress file and decompress input stream is null", new Object[0]);
        }
        if (this.decompressTargetPath == null) {
            Assert.notNull(this.decompressTargetOutputStream, "decompress target path and is decompress target output stream null", new Object[0]);
        }
        this.doDecompress();
    }

    public void setDecompressInputStream(InputStream decompressInputStream) {
        this.decompressInputStream = decompressInputStream;
    }

    public void setDecompressTargetOutputStream(OutputStream decompressTargetOutputStream) {
        this.decompressTargetOutputStream = decompressTargetOutputStream;
    }

    public void setDecompressTargetFileName(String decompressTargetFileName) {
        this.decompressTargetFileName = decompressTargetFileName;
    }

    @Override
    public void doDecompress() throws Exception {
        OutputStream out = null;
        try {
            this.inputStream = this.decompressInputStream != null ? new BZip2CompressorInputStream(this.decompressInputStream) : new BZip2CompressorInputStream(Files1.openInputStreamFast(this.decompressFile));
            if (this.decompressTargetFileName == null) {
                this.decompressTargetFileName = Optional.ofNullable(this.decompressFile).map(File::getName).map(s -> s.substring(0, s.length() - this.suffix.length() - 1)).orElseGet(ObjectIds::nextId);
            }
            if (this.decompressTargetOutputStream != null) {
                out = this.decompressTargetOutputStream;
            } else {
                this.decompressTargetFile = new File(this.decompressTargetPath, this.decompressTargetFileName);
                out = Files1.openOutputStream(this.decompressTargetFile);
            }
            Streams.transfer((InputStream)this.inputStream, out);
        }
        catch (Throwable throwable) {
            Streams.close((AutoCloseable)this.inputStream);
            if (this.decompressTargetOutputStream == null) {
                Streams.close(out);
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)this.inputStream);
        if (this.decompressTargetOutputStream == null) {
            Streams.close(out);
        }
    }

    public File getDecompressTargetFile() {
        return this.decompressTargetFile;
    }

    public BZip2CompressorInputStream getCloseable() {
        return this.inputStream;
    }
}

