/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress.gz;

import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.io.compress.BaseFileCompressor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

public class GzCompressor
extends BaseFileCompressor {
    private GzipCompressorOutputStream outputStream;
    private File compressFile;
    private InputStream compressInputStream;
    private OutputStream compressOutputStream;
    private String compressEntityName;

    public GzCompressor() {
        this("gz");
    }

    public GzCompressor(String suffix) {
        super(suffix);
    }

    @Override
    public void addFile(String file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(File file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, String file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, File file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFilePrefix(String prefix, String file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFilePrefix(String prefix, File file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, byte[] bs) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, InputStream in) {
        this.unsupportedOperation();
    }

    public void setCompressFile(String file) {
        Assert.notBlank(file, "compress file is null", new Object[0]);
        this.setCompressFile(new File(file));
    }

    public void setCompressFile(File file) {
        Assert.notNull(file, "compress file is null", new Object[0]);
        Assert.isTrue(Files1.isFile(file), "compress file must be a normal file", new Object[0]);
        this.compressFile = file;
        this.compressEntityName = file.getName();
        this.setFileName(file.getName());
    }

    public void setCompressFile(byte[] bs) {
        this.setCompressFile(null, bs);
    }

    public void setCompressFile(String name, byte[] bs) {
        this.compressEntityName = name;
        this.compressInputStream = Streams.toInputStream(bs);
        if (name != null) {
            this.setFileName(name);
        }
    }

    public void setCompressFile(InputStream in) {
        this.setCompressFile(null, in);
    }

    public void setCompressFile(String name, InputStream in) {
        this.compressEntityName = name;
        this.compressInputStream = in;
        if (name != null) {
            this.setFileName(name);
        }
    }

    public void setCompressOutputStream(OutputStream compressOutputStream) {
        this.compressOutputStream = compressOutputStream;
    }

    @Override
    public void compress() throws Exception {
        Assert.isFalse(this.compressFile == null && this.compressInputStream == null, "gzip compress file just support compress one file", new Object[0]);
        this.doCompress();
    }

    @Override
    public void doCompress() throws Exception {
        GzipParameters params = new GzipParameters();
        params.setFilename(this.compressEntityName);
        InputStream in = null;
        try {
            this.outputStream = this.compressOutputStream != null ? new GzipCompressorOutputStream(this.compressOutputStream, params) : new GzipCompressorOutputStream(Files1.openOutputStreamFast(new File(this.getAbsoluteCompressPath())), params);
            in = this.compressInputStream != null ? this.compressInputStream : Files1.openInputStreamFast(this.compressFile);
            Streams.transfer(in, (OutputStream)this.outputStream);
            super.notify(this.compressEntityName);
        }
        catch (Throwable throwable) {
            Streams.close((AutoCloseable)this.outputStream);
            if (this.compressInputStream == null) {
                Streams.close(in);
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)this.outputStream);
        if (this.compressInputStream == null) {
            Streams.close(in);
        }
    }

    public GzipCompressorOutputStream getCloseable() {
        return this.outputStream;
    }
}

