/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.json.matcher;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.json.matcher.ErrorStrategy;
import cn.orionsec.kit.lang.utils.json.matcher.NoMatchStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ReplacementFormatter {
    private final Pattern pattern;
    private final String prefix;
    private final String suffix;
    private NoMatchStrategy noMatchStrategy;
    private ErrorStrategy errorStrategy;
    private Map<String, Object> defaults;

    public ReplacementFormatter(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.pattern = this.createPattern();
        this.noMatchStrategy = NoMatchStrategy.EMPTY;
        this.errorStrategy = ErrorStrategy.THROW;
    }

    private Pattern createPattern() {
        String evalPrefix = this.prefix.chars().mapToObj(s -> "\\" + (char)s).collect(Collectors.joining());
        String evalSuffix = this.suffix.chars().mapToObj(s -> "\\" + (char)s).collect(Collectors.joining());
        return Pattern.compile("(" + evalPrefix + ")(.+?)(" + evalSuffix + ")");
    }

    public ReplacementFormatter noMatchStrategy(NoMatchStrategy noMatchStrategy) {
        this.noMatchStrategy = noMatchStrategy;
        return this;
    }

    public ReplacementFormatter errorStrategy(ErrorStrategy errorStrategy) {
        this.errorStrategy = errorStrategy;
        return this;
    }

    public ReplacementFormatter defaultValue(String key, Object value) {
        if (this.defaults == null) {
            this.defaults = new HashMap<String, Object>();
        }
        this.defaults.put(key, value);
        return this;
    }

    public ReplacementFormatter defaultValue(Map<String, ?> map) {
        if (this.defaults == null) {
            this.defaults = new HashMap<String, Object>();
        }
        this.defaults.putAll(map);
        return this;
    }

    public String format(String template, Object o) {
        return this.format(template, JSON.toJSONString((Object)o));
    }

    public String format(String template, String json) {
        if (Strings.isAnyEmpty(template, json)) {
            return template;
        }
        String result = template;
        Matcher matcher = this.pattern.matcher(template);
        while (matcher.find()) {
            String replacement = matcher.group();
            String path = replacement.substring(this.prefix.length(), replacement.length() - this.suffix.length()).trim();
            Object readValue = null;
            try {
                readValue = JSONPath.read((String)json, (String)path);
                if (readValue == null && this.defaults != null) {
                    readValue = this.defaults.get(path);
                }
            }
            catch (Exception e) {
                if (ErrorStrategy.DEFAULT.equals((Object)this.errorStrategy)) {
                    if (this.defaults != null) {
                        readValue = this.defaults.get(path);
                    }
                }
                if (ErrorStrategy.EMPTY.equals((Object)this.errorStrategy)) {
                    readValue = "";
                }
                if (!ErrorStrategy.THROW.equals((Object)this.errorStrategy)) continue;
                throw Exceptions.argument("parse argument " + path + " error", e);
            }
            if (readValue == null) {
                if (NoMatchStrategy.EMPTY.equals((Object)this.noMatchStrategy)) {
                    readValue = "";
                } else {
                    if (!NoMatchStrategy.THROW.equals((Object)this.noMatchStrategy)) continue;
                    throw Exceptions.argument("argument " + path + " is null");
                }
            }
            result = result.replace(replacement, Objects1.toString(readValue));
        }
        return result;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public NoMatchStrategy getNoMatchStrategy() {
        return this.noMatchStrategy;
    }

    public ErrorStrategy getErrorStrategy() {
        return this.errorStrategy;
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }
}

