/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.net;

import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class Ports {
    private static final int TIMEOUT = 3000;

    private Ports() {
    }

    public static int getFreePort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            Streams.close(serverSocket);
            return port;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getFreePort(int[] ports) {
        for (int port : ports) {
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                Streams.close(serverSocket);
                return port;
            }
            catch (Exception exception) {
            }
        }
        return -1;
    }

    public static int getFreePort(int start, int end) {
        Assert.gte(start, 1001, "start port must greater than 1000", new Object[0]);
        Assert.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Assert.gt(end, start, "end port must greater than start", new Object[0]);
        for (int i = start; i <= end; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                Streams.close(serverSocket);
                return i;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return -1;
    }

    public static List<Integer> getFreePorts(int[] ports) {
        ArrayList<Integer> freePorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                Streams.close(serverSocket);
                freePorts.add(port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return freePorts;
    }

    public static List<Integer> getFreePorts(int start, int end) {
        Assert.gte(start, 1001, "start port must greater than 1000", new Object[0]);
        Assert.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Assert.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> freePorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                Streams.close(serverSocket);
                freePorts.add(i);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return freePorts;
    }

    public static List<Integer> getUsedPorts(int[] ports) {
        ArrayList<Integer> usedPorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                Streams.close(serverSocket);
            }
            catch (Exception e) {
                usedPorts.add(port);
            }
        }
        return usedPorts;
    }

    public static List<Integer> getUsedPorts(int start, int end) {
        Assert.gte(start, 1001, "start port must greater than 1000", new Object[0]);
        Assert.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Assert.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> usedPorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                Streams.close(serverSocket);
                continue;
            }
            catch (IOException ex) {
                usedPorts.add(i);
            }
        }
        return usedPorts;
    }

    public static boolean isFree(int port) {
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            Streams.close(serverSocket);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isUsed(int port) {
        return Ports.isFree(port);
    }

    public static boolean isOpen(String host, int port) {
        return Ports.isOpen(host, port, 3000);
    }

    public static boolean isOpen(String host, int port, int timeout) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            Streams.close(socket);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isClose(String host, int port) {
        return !Ports.isOpen(host, port);
    }

    public static boolean isClose(String host, int port, int timeout) {
        return !Ports.isOpen(host, port, timeout);
    }

    public static List<Integer> getOpenPorts(String host, int[] ports) {
        return Ports.getOpenPorts(host, ports, 3000);
    }

    public static List<Integer> getOpenPorts(String host, int[] ports, int timeout) {
        ArrayList<Integer> openedPorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                Streams.close(socket);
                openedPorts.add(port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return openedPorts;
    }

    public static List<Integer> getOpenPorts(String host, int start, int end) {
        return Ports.getOpenPorts(host, start, end, 3000);
    }

    public static List<Integer> getOpenPorts(String host, int start, int end, int timeout) {
        Assert.gt(start, 0, "start port must greater than 0", new Object[0]);
        Assert.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Assert.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> openedPorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, i), timeout);
                Streams.close(socket);
                openedPorts.add(i);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return openedPorts;
    }

    public static List<Integer> getClosePorts(String host, int[] ports) {
        return Ports.getClosePorts(host, ports, 3000);
    }

    public static List<Integer> getClosePorts(String host, int[] ports, int timeout) {
        ArrayList<Integer> closedPorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                Streams.close(socket);
            }
            catch (Exception e) {
                closedPorts.add(port);
            }
        }
        return closedPorts;
    }

    public static List<Integer> getClosePorts(String host, int start, int end) {
        return Ports.getClosePorts(host, start, end, 3000);
    }

    public static List<Integer> getClosePorts(String host, int start, int end, int timeout) {
        Assert.gt(start, 0, "start port must greater than 0", new Object[0]);
        Assert.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Assert.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> closedPorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, i), timeout);
                Streams.close(socket);
                continue;
            }
            catch (IOException ex) {
                closedPorts.add(i);
            }
        }
        return closedPorts;
    }
}

