/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.define.collect.MutableHashMap;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.reflect.Constructors;
import cn.orionsec.kit.lang.utils.reflect.Fields;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Annotations {
    private Annotations() {
    }

    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotation) {
        return clazz.getDeclaredAnnotation(annotation);
    }

    public static <A extends Annotation> List<A> getAnnotations(Class<?> clazz, Class<A> annotation) {
        return Lists.of(clazz.getDeclaredAnnotationsByType(annotation));
    }

    public static <A extends Annotation> A getAnnotations(Class<?> clazz, Class<A> annotation, int index) {
        List<Annotation> list = Lists.of(clazz.getDeclaredAnnotationsByType(annotation));
        if (list.size() <= index) {
            return null;
        }
        return (A)list.get(index);
    }

    public static List<Annotation> getAnnotations(Class<?> clazz) {
        return Lists.of(clazz.getDeclaredAnnotations());
    }

    public static <A extends Annotation> A getAnnotations(Class<?> clazz, int index) {
        List<Annotation> list = Lists.of(clazz.getDeclaredAnnotations());
        if (list.size() <= index) {
            return null;
        }
        return (A)list.get(index);
    }

    public static <A extends Annotation> A getAnnotation(Constructor<?> constructor, Class<A> annotation) {
        return constructor.getDeclaredAnnotation(annotation);
    }

    public static List<Annotation> getAnnotations(Constructor<?> constructor) {
        return Lists.of(constructor.getDeclaredAnnotations());
    }

    public static <A extends Annotation> A getAnnotations(Constructor<?> constructor, int index) {
        List<Annotation> list = Lists.of(constructor.getDeclaredAnnotations());
        if (list.size() <= index) {
            return null;
        }
        return (A)list.get(index);
    }

    public static <A extends Annotation> A getAnnotation(Field field, Class<A> annotation) {
        return field.getDeclaredAnnotation(annotation);
    }

    public static List<Annotation> getAnnotations(Field field) {
        return Lists.of(field.getDeclaredAnnotations());
    }

    public static <A extends Annotation> A getAnnotations(Field field, int index) {
        List<Annotation> list = Lists.of(field.getDeclaredAnnotations());
        if (list.size() <= index) {
            return null;
        }
        return (A)list.get(index);
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotation) {
        return method.getDeclaredAnnotation(annotation);
    }

    public static List<Annotation> getAnnotations(Method method) {
        return Lists.of(method.getDeclaredAnnotations());
    }

    public static <A extends Annotation> A getAnnotations(Method method, int index) {
        List<Annotation> list = Lists.of(method.getDeclaredAnnotations());
        if (list.size() <= index) {
            return null;
        }
        return (A)list.get(index);
    }

    public static <A extends Annotation> A getParameterAnnotation(Constructor<?> constructor, int paramIndex, Class<A> annotation) {
        Annotation[][] annotations = constructor.getParameterAnnotations();
        if (annotations.length <= paramIndex) {
            return null;
        }
        for (Annotation a : annotations[paramIndex]) {
            if (!a.annotationType().equals(annotation)) continue;
            return (A)a;
        }
        return null;
    }

    public static <A extends Annotation> A getParameterAnnotation(Constructor<?> constructor, int paramIndex, int index) {
        Annotation[][] annotations = constructor.getParameterAnnotations();
        if (annotations.length <= paramIndex) {
            return null;
        }
        Annotation[] a = annotations[paramIndex];
        if (a.length <= index) {
            return null;
        }
        return (A)a[index];
    }

    public static List<Annotation> getParameterAnnotation(Constructor<?> constructor, int paramIndex) {
        Annotation[][] annotations = constructor.getParameterAnnotations();
        if (annotations.length <= paramIndex) {
            return new ArrayList<Annotation>();
        }
        return Lists.of(annotations[paramIndex]);
    }

    public static List<List<Annotation>> getParameterAnnotation(Constructor<?> constructor) {
        Annotation[][] annotations = constructor.getParameterAnnotations();
        ArrayList<List<Annotation>> list = new ArrayList<List<Annotation>>();
        for (Annotation[] annotation : annotations) {
            list.add(Lists.of(annotation));
        }
        return list;
    }

    public static <A extends Annotation> A getParameterAnnotation(Method method, int paramIndex, Class<A> annotation) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length <= paramIndex) {
            return null;
        }
        for (Annotation a : annotations[paramIndex]) {
            if (!a.annotationType().equals(annotation)) continue;
            return (A)a;
        }
        return null;
    }

    public static <A extends Annotation> A getParameterAnnotation(Method method, int paramIndex, int index) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length <= paramIndex) {
            return null;
        }
        Annotation[] a = annotations[paramIndex];
        if (a.length <= index) {
            return null;
        }
        return (A)a[index];
    }

    public static List<Annotation> getParameterAnnotation(Method method, int paramIndex) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length <= paramIndex) {
            return new ArrayList<Annotation>();
        }
        return Lists.of(annotations[paramIndex]);
    }

    public static List<List<Annotation>> getParameterAnnotation(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        ArrayList<List<Annotation>> list = new ArrayList<List<Annotation>>();
        for (Annotation[] annotation : annotations) {
            list.add(Lists.of(annotation));
        }
        return list;
    }

    @SafeVarargs
    public static boolean present(Class<?> clazz, Class<? extends Annotation> ... annotatedClasses) {
        Assert.notNull(clazz, "class is null", new Object[0]);
        Assert.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        if (annotatedClasses.length == 1) {
            return clazz.isAnnotationPresent(annotatedClasses[0]);
        }
        return Arrays.stream(annotatedClasses).allMatch(clazz::isAnnotationPresent);
    }

    @SafeVarargs
    public static boolean present(Constructor<?> constructor, Class<? extends Annotation> ... annotatedClasses) {
        Assert.notNull(constructor, "constructor is null", new Object[0]);
        Assert.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        if (annotatedClasses.length == 1) {
            return constructor.isAnnotationPresent(annotatedClasses[0]);
        }
        return Arrays.stream(annotatedClasses).allMatch(constructor::isAnnotationPresent);
    }

    @SafeVarargs
    public static boolean present(Method method, Class<? extends Annotation> ... annotatedClasses) {
        Assert.notNull(method, "method is null", new Object[0]);
        Assert.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        if (annotatedClasses.length == 1) {
            return method.isAnnotationPresent(annotatedClasses[0]);
        }
        return Arrays.stream(annotatedClasses).allMatch(method::isAnnotationPresent);
    }

    @SafeVarargs
    public static boolean present(Field field, Class<? extends Annotation> ... annotatedClasses) {
        Assert.notNull(field, "field is null", new Object[0]);
        Assert.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        if (annotatedClasses.length == 1) {
            return field.isAnnotationPresent(annotatedClasses[0]);
        }
        return Arrays.stream(annotatedClasses).allMatch(field::isAnnotationPresent);
    }

    public static <A extends Annotation> A cast(Annotation a) {
        return (A)a;
    }

    public static <A extends Annotation, E> E getValue(A annotated) {
        return Annotations.getAttribute(annotated, "value");
    }

    public static <A extends Annotation, E> E getAttribute(A annotated, String attributeName) {
        try {
            Method method = annotated.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            method.setAccessible(true);
            return (E)method.invoke(annotated, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <A extends Annotation> MutableHashMap<String, Object> getAttributes(A annotated) {
        Method[] methods;
        MutableHashMap<String, Object> attrs = new MutableHashMap<String, Object>();
        for (Method method : methods = annotated.annotationType().getDeclaredMethods()) {
            method.setAccessible(true);
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            try {
                attrs.put(method.getName(), method.invoke(annotated, new Object[0]));
            }
            catch (Exception e) {
                throw Exceptions.invoke("could not obtain annotation attribute values", e);
            }
        }
        return attrs;
    }

    public static <A extends Annotation, E> E getDefaultValue(A annotated) {
        return Annotations.getDefaultValue(annotated.annotationType(), "value");
    }

    public static <A extends Annotation, E> E getDefaultValue(A annotated, String attributeName) {
        return Annotations.getDefaultValue(annotated.annotationType(), attributeName);
    }

    public static <E> E getDefaultValue(Class<? extends Annotation> annotatedClass) {
        return Annotations.getDefaultValue(annotatedClass, "value");
    }

    public static <E> E getDefaultValue(Class<? extends Annotation> annotatedClass, String attributeName) {
        try {
            Method method = annotatedClass.getDeclaredMethod(attributeName, new Class[0]);
            method.setAccessible(true);
            return (E)method.getDefaultValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <C, T extends Annotation> Map<Constructor<C>, T> getAnnotatedConstructor(Class<C> targetClass, Class<T> annotatedClass) {
        LinkedHashMap<Constructor<C>, T> map = new LinkedHashMap<Constructor<C>, T>();
        List<Constructor<C>> constructors = Constructors.getConstructors(targetClass);
        for (Constructor<C> c : constructors) {
            T annotation = Annotations.getAnnotation(c, annotatedClass);
            if (annotation == null) continue;
            map.put(c, annotation);
        }
        return map;
    }

    public static <T extends Annotation> Map<Field, T> getAnnotatedFields(Class<?> targetClass, Class<T> annotatedClass) {
        return Annotations.getAnnotatedFields(targetClass, annotatedClass, false);
    }

    public static <T extends Annotation> Map<Field, T> getAnnotatedFields(Class<?> targetClass, Class<T> annotatedClass, boolean byCache) {
        List<Field> fields = byCache ? Fields.getFieldsByCache(targetClass) : Fields.getFields(targetClass);
        LinkedHashMap<Field, T> map = new LinkedHashMap<Field, T>();
        for (Field field : fields) {
            T annotation = Annotations.getAnnotation(field, annotatedClass);
            if (annotation == null) continue;
            map.put(field, annotation);
        }
        return map;
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedGetterMethods(Class<?> targetClass, Class<T> annotatedClass) {
        return Annotations.getAnnotatedGetterMethods(targetClass, annotatedClass, false);
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedGetterMethods(Class<?> targetClass, Class<T> annotatedClass, boolean byCache) {
        List<Method> methods = byCache ? Methods.getGetterMethodsByCache(targetClass) : Methods.getGetterMethods(targetClass);
        return Annotations.getAnnotatedMethods(methods, annotatedClass);
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedSetterMethods(Class<?> targetClass, Class<T> annotatedClass) {
        return Annotations.getAnnotatedSetterMethods(targetClass, annotatedClass, false);
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedSetterMethods(Class<?> targetClass, Class<T> annotatedClass, boolean byCache) {
        List<Method> methods = byCache ? Methods.getSetterMethodsByCache(targetClass) : Methods.getSetterMethods(targetClass);
        return Annotations.getAnnotatedMethods(methods, annotatedClass);
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedMethods(List<Method> methods, Class<T> annotatedClass) {
        LinkedHashMap<Method, T> map = new LinkedHashMap<Method, T>();
        for (Method method : methods) {
            T annotation = Annotations.getAnnotation(method, annotatedClass);
            if (annotation == null) continue;
            map.put(method, annotation);
        }
        return map;
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedGetterMethodsMergeField(Class<?> targetClass, Class<T> annotatedClass) {
        return Annotations.getAnnotatedMethodsMergeField(targetClass, annotatedClass, true, false);
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedGetterMethodsMergeField(Class<?> targetClass, Class<T> annotatedClass, boolean byCache) {
        return Annotations.getAnnotatedMethodsMergeField(targetClass, annotatedClass, true, byCache);
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedSetterMethodsMergeField(Class<?> targetClass, Class<T> annotatedClass) {
        return Annotations.getAnnotatedMethodsMergeField(targetClass, annotatedClass, false, false);
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedSetterMethodsMergeField(Class<?> targetClass, Class<T> annotatedClass, boolean byCache) {
        return Annotations.getAnnotatedMethodsMergeField(targetClass, annotatedClass, false, byCache);
    }

    private static <T extends Annotation> Map<Method, T> getAnnotatedMethodsMergeField(Class<?> targetClass, Class<T> annotatedClass, boolean isGetter, boolean byCache) {
        T annotation;
        LinkedHashMap<Method, T> map = new LinkedHashMap<Method, T>();
        List<Object> fields = new ArrayList();
        List<Object> methods = new ArrayList();
        if (byCache) {
            methods = isGetter ? Methods.getGetterMethodsByCache(targetClass) : Methods.getSetterMethodsByCache(targetClass);
            fields = Fields.getFields(targetClass);
        } else {
            methods = isGetter ? Methods.getGetterMethods(targetClass) : Methods.getSetterMethods(targetClass);
            fields = Fields.getFields(targetClass);
        }
        Map<String, Method> mapping = methods.stream().collect(Collectors.toMap(Method::getName, s -> s));
        for (Field field : fields) {
            String methodName;
            Method method;
            annotation = Annotations.getAnnotation(field, annotatedClass);
            if (annotation == null || (method = mapping.get(methodName = isGetter ? Methods.getGetterMethodNameByField(field) : Methods.getSetterMethodNameByField(field))) == null) continue;
            map.put(method, annotation);
        }
        for (Method method : methods) {
            annotation = Annotations.getAnnotation(method, annotatedClass);
            if (annotation == null) continue;
            map.put(method, annotation);
        }
        return map;
    }
}

