/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.define.collect.MutableLinkedHashMap;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.VariableStyles;
import cn.orionsec.kit.lang.utils.reflect.Fields;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import java.lang.reflect.Method;
import java.util.List;

public class BeanMap
extends MutableLinkedHashMap<String, Object> {
    private final Object o;
    private final String[] ignoreFields;
    private final boolean addNull;
    private final VariableStyles variableStyle;

    public BeanMap(Object o, String ... ignoreFields) {
        this(o, null, false, ignoreFields);
    }

    public BeanMap(Object o, VariableStyles variableStyle, String ... ignoreFields) {
        this(o, variableStyle, false, ignoreFields);
    }

    public BeanMap(Object o, boolean addNull, String ... ignoreFields) {
        this(o, null, addNull, ignoreFields);
    }

    public BeanMap(Object o, VariableStyles variableStyle, boolean addNull, String ... ignoreFields) {
        Assert.notNull(o, "object is null", new Object[0]);
        this.o = o;
        this.variableStyle = variableStyle;
        this.addNull = addNull;
        this.ignoreFields = ignoreFields;
        this.invokeGetter(Methods.getGetterMethodsByCache(o.getClass()));
    }

    public static BeanMap create(Object o, String ... ignoreFields) {
        return new BeanMap(o, null, true, ignoreFields);
    }

    public static BeanMap create(Object o, boolean addNull, String ... ignoreFields) {
        return new BeanMap(o, null, addNull, ignoreFields);
    }

    public static BeanMap create(Object o, VariableStyles variableStyle, String ... ignoreFields) {
        return new BeanMap(o, variableStyle, true, ignoreFields);
    }

    public static BeanMap create(Object o, VariableStyles variableStyle, boolean addNull, String ... ignoreFields) {
        return new BeanMap(o, variableStyle, addNull, ignoreFields);
    }

    private void invokeGetter(List<Method> methods) {
        for (Method method : methods) {
            Object value;
            String fieldName = Fields.getFieldNameByMethod(method.getName());
            if (this.isIgnoreField(fieldName)) continue;
            if (this.variableStyle != null) {
                fieldName = VariableStyles.convert(fieldName, this.variableStyle);
            }
            if ((value = Methods.invokeMethod(this.o, method)) == null) {
                if (!this.addNull) continue;
                this.put(fieldName, null);
                continue;
            }
            this.put(fieldName, value);
        }
    }

    private boolean isIgnoreField(String field) {
        if (Arrays1.isEmpty(this.ignoreFields)) {
            return false;
        }
        for (String ignoreField : this.ignoreFields) {
            if (!field.equals(ignoreField)) continue;
            return true;
        }
        return false;
    }

    public <T> T getValue() {
        return (T)this.o;
    }
}

