/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.define.collect.ConcurrentReferenceHashMap;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.reflect.Fields;
import cn.orionsec.kit.lang.utils.reflect.TypeInfer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Methods {
    protected static final String SETTER_PREFIX = "set";
    protected static final String GETTER_PREFIX = "get";
    protected static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final Map<Class<?>, List<Method>> CLASS_SET_METHOD_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private static final Map<Class<?>, List<Method>> CLASS_GET_METHOD_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    private Methods() {
    }

    public static Method getGetterMethodByCache(Class<?> clazz, String field) {
        List<Method> methods = Methods.getGetterMethodsByCache(clazz);
        if (methods == null) {
            return null;
        }
        String methodName = Methods.getGetterMethodNameByField(field, false);
        for (Method method : methods) {
            if (method.getParameterCount() != 0 || !method.getName().equals(methodName)) continue;
            return method;
        }
        methodName = Methods.getGetterMethodNameByField(field, true);
        for (Method method : methods) {
            if (method.getParameterCount() != 0 || !method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Method getSetterMethodByCache(Class<?> clazz, String field) {
        List<Method> methods = Methods.getSetterMethodsByCache(clazz);
        if (methods == null) {
            return null;
        }
        String methodName = Methods.getSetterMethodNameByField(field);
        for (Method method : methods) {
            if (method.getParameterCount() != 1 || !method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static List<Method> getGetterMethodsByCache(Class<?> clazz) {
        List<Method> methodList = CLASS_GET_METHOD_CACHE.get(clazz);
        if (methodList == null) {
            methodList = Methods.getGetterMethods(clazz);
            CLASS_GET_METHOD_CACHE.put(clazz, methodList);
        }
        return methodList;
    }

    public static List<Method> getSetterMethodsByCache(Class<?> clazz) {
        List<Method> methodList = CLASS_SET_METHOD_CACHE.get(clazz);
        if (methodList == null) {
            methodList = Methods.getSetterMethods(clazz);
            CLASS_SET_METHOD_CACHE.put(clazz, methodList);
        }
        return methodList;
    }

    public static String getGetterMethodNameByField(Field field) {
        return Methods.getGetterMethodNameByField(field.getName(), field.getType().equals(Boolean.TYPE));
    }

    public static String getGetterMethodNameByField(String fieldName) {
        return Methods.getGetterMethodNameByField(fieldName, false);
    }

    public static String getGetterMethodNameByField(String fieldName, boolean isBooleanClass) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        if (fieldName.length() > 2 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1))) {
            return (isBooleanClass ? BOOLEAN_GETTER_PREFIX : GETTER_PREFIX) + fieldName;
        }
        return (isBooleanClass ? BOOLEAN_GETTER_PREFIX : GETTER_PREFIX) + Strings.firstUpper(fieldName);
    }

    public static String getSetterMethodNameByField(Field field) {
        return Methods.getSetterMethodNameByField(field.getName());
    }

    public static String getSetterMethodNameByField(String fieldName) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        if (fieldName.length() > 2 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1))) {
            return SETTER_PREFIX + fieldName;
        }
        return SETTER_PREFIX + Strings.firstUpper(fieldName);
    }

    public static List<Method> getGetterMethods(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if ("getClass".equals(method.getName()) || Modifier.isStatic(method.getModifiers()) || method.getParameters().length != 0) continue;
            String name = method.getName();
            if (name.startsWith(GETTER_PREFIX) && name.length() != 3 && !method.getReturnType().equals(Void.TYPE)) {
                Methods.setAccessible(method);
                list.add(method);
                continue;
            }
            if (!method.getName().startsWith(BOOLEAN_GETTER_PREFIX) || name.length() == 2 || !method.getReturnType().equals(Boolean.TYPE)) continue;
            Methods.setAccessible(method);
            list.add(method);
        }
        return list;
    }

    public static List<Method> getSetterMethods(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            String name = method.getName();
            if (!name.startsWith(SETTER_PREFIX) || name.length() == 3 || Modifier.isStatic(method.getModifiers()) || method.getParameters().length != 1) continue;
            Methods.setAccessible(method);
            list.add(method);
        }
        return list;
    }

    public static List<Method> getGetterMethodsByField(Class<?> clazz) {
        return Fields.getFields(clazz).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).map(field -> Methods.getGetterMethodByField(clazz, field)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Method> getSetterMethodsByField(Class<?> clazz) {
        return Fields.getFields(clazz).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).map(field -> Methods.getSetterMethodByField(clazz, field)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Method getGetterMethodByField(Class<?> clazz, Field field) {
        return Methods.getGetterMethodByField(clazz, field.getName());
    }

    public static Method getGetterMethodByField(Class<?> clazz, String fieldName) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        Method method = Methods.getAccessibleMethod(clazz, Methods.getGetterMethodNameByField(fieldName, false), 0);
        if (method == null) {
            method = Methods.getAccessibleMethod(clazz, Methods.getGetterMethodNameByField(fieldName, true), 0);
        }
        return method;
    }

    public static Method getSetterMethodByField(Class<?> clazz, Field field) {
        return Methods.getSetterMethodByField(clazz, field.getName());
    }

    public static Method getSetterMethodByField(Class<?> clazz, String fieldName) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        return Methods.getAccessibleMethod(clazz, Methods.getSetterMethodNameByField(fieldName), 1);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull(clazz, "method class is null", new Object[0]);
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                Methods.setAccessible(method);
                return method;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, int argsNum) {
        Assert.notNull(clazz, "method class is null", new Object[0]);
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != argsNum) continue;
                Methods.setAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName) {
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Methods.setAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static List<Method> getAccessibleMethods(Class<?> clazz, String methodName, int argsNum) {
        Assert.notNull(clazz, "method class is null", new Object[0]);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] searchMethods;
            for (Method method : searchMethods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != argsNum) continue;
                Methods.setAccessible(method);
                methods.add(method);
            }
        }
        return methods;
    }

    public static List<Method> getAccessibleMethods(Class<?> clazz, String methodName) {
        Assert.notNull(clazz, "method class is null", new Object[0]);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] searchMethods;
            for (Method method : searchMethods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Methods.setAccessible(method);
                methods.add(method);
            }
        }
        return methods;
    }

    public static List<Method> getAccessibleMethods(Class<?> clazz) {
        Assert.notNull(clazz, "method class is null", new Object[0]);
        if (clazz.getSuperclass() != null) {
            List methodList = Stream.of(clazz.getDeclaredMethods()).filter(field -> !Modifier.isStatic(field.getModifiers())).peek(Methods::setAccessible).collect(Collectors.toCollection(ArrayList::new));
            Class<?> superClass = clazz.getSuperclass();
            Map methodMap = methodList.stream().collect(Collectors.toMap(Method::getName, Function.identity()));
            Methods.getAccessibleMethods(superClass).stream().filter(m -> !methodMap.containsKey(m.getName())).forEach(methodList::add);
            return methodList;
        }
        return new ArrayList<Method>();
    }

    public static Map<String, Method> getAccessibleMethodMap(Class<?> clazz) {
        List<Method> methodList = Methods.getAccessibleMethods(clazz);
        return Lists.isNotEmpty(methodList) ? methodList.stream().collect(Collectors.toMap(Method::getName, Function.identity())) : new HashMap<String, Method>();
    }

    public static void setAccessible(Method method) {
        Assert.notNull(method, "set accessible method class is null", new Object[0]);
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static List<Method> getStaticMethods(Class<?> clazz) {
        Assert.notNull(clazz, "class is null", new Object[0]);
        return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
    }

    public static <E> E invokeGetter(Object obj, String fieldName) {
        Assert.notNull(obj, "invoke object is null", new Object[0]);
        Assert.notBlank(fieldName, "invoke getter field is null", new Object[0]);
        try {
            Method method = Methods.getGetterMethodByField(obj.getClass(), fieldName);
            return Methods.invokeMethod(obj, method);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("invoke field: {} setter method error {}", fieldName, e.getMessage()), e);
        }
    }

    @SafeVarargs
    public static <E> void invokeSetterChain(Object obj, String fields, E ... values) {
        Assert.notNull(obj, "invoke object is null", new Object[0]);
        Assert.notBlank(fields, "invoke Setter Method is null", new Object[0]);
        String[] names = fields.split("\\.");
        if (names.length != Arrays1.length(values)) {
            throw Exceptions.argument("setting method and parameter length are inconsistent");
        }
        for (int i = 0; i < names.length; ++i) {
            Methods.invokeSetter(obj, names[i], values[i]);
        }
    }

    @SafeVarargs
    public static <E> void invokeSetterChainInfer(Object obj, String fields, E ... values) {
        Assert.notNull(obj, "invoke object is null", new Object[0]);
        Assert.notBlank(fields, "invoke Setter Method is null", new Object[0]);
        String[] names = fields.split("\\.");
        if (names.length != Arrays1.length(values)) {
            throw Exceptions.argument("setting method and parameter length are inconsistent");
        }
        for (int i = 0; i < names.length; ++i) {
            Methods.invokeSetterInfer(obj, names[i], values[i]);
        }
    }

    public static <E> void invokeSetter(Object obj, String fieldName, E value) {
        Methods.invokeMethod(obj, Methods.getSetterMethodByField(obj.getClass(), fieldName), value);
    }

    public static <E> void invokeSetterInfer(Object obj, String fieldName, E value) {
        Methods.invokeMethodInfer(obj, Methods.getSetterMethodByField(obj.getClass(), fieldName), value);
    }

    public static <E> void invokeSetterInfer(Object obj, Method method, E value) {
        Methods.invokeMethodInfer(obj, method, value);
    }

    public static <E> E invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object ... args) {
        Assert.notNull(obj, "invoker object is null", new Object[0]);
        Assert.notBlank(methodName, "invoke method is null", new Object[0]);
        Method method = Methods.getAccessibleMethod(obj.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw Exceptions.invoke(Strings.format("method {} not found in class {}", methodName, obj.getClass()));
        }
        return Methods.invokeMethod(obj, method, args);
    }

    public static <E> E invokeMethod(Object obj, String methodName) {
        return Methods.invokeMethod(obj, methodName, (Object[])null);
    }

    public static <E> E invokeMethod(Object obj, Method method) {
        return Methods.invokeMethod(obj, method, (Object[])null);
    }

    public static <E> E invokeMethod(Object obj, String methodName, Object ... args) {
        Assert.notNull(obj, "invoker object is null", new Object[0]);
        Assert.notBlank(methodName, "invoke method is null", new Object[0]);
        Method method = Methods.getAccessibleMethod(obj.getClass(), methodName, Arrays1.length(args));
        if (method == null) {
            throw Exceptions.invoke(Strings.format("invoke method error: {} not found in class {}", methodName, obj.getClass().getName()));
        }
        return Methods.invokeMethod(obj, method, args);
    }

    public static <E> E invokeMethod(Object obj, Method method, Object ... args) {
        Assert.notNull(obj, "invoke object is null", new Object[0]);
        Assert.notNull(method, "invoke method is null", new Object[0]);
        try {
            Methods.setAccessible(method);
            return (E)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("invoke method error: {}, class: {}, args: {}", method.getName(), obj.getClass().getName(), Arrays.toString(args)), e);
        }
    }

    public static <E> E invokeMethodInfer(Object obj, String methodName, Object ... args) {
        Assert.notNull(obj, "invoke object is null", new Object[0]);
        Assert.notBlank(methodName, "invoke method is null", new Object[0]);
        if (Arrays1.isEmpty(args)) {
            return Methods.invokeMethod(obj, methodName, (Object[])null);
        }
        int len = Arrays1.length(args);
        List<Method> methods = Methods.getAccessibleMethods(obj.getClass(), methodName, len);
        return (E)TypeInfer.invokeInfer(obj, methods, args);
    }

    public static <E> E invokeMethodInfer(Object obj, Method method, Object ... args) {
        Assert.notNull(obj, "invoke object is null", new Object[0]);
        Assert.notNull(method, "invoke method is null", new Object[0]);
        if (Arrays1.isEmpty(args)) {
            return Methods.invokeMethod(obj, method, (Object[])null);
        }
        return (E)TypeInfer.invokeInfer(obj, Lists.singleton(method), args);
    }
}

