/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Urls;
import cn.orionsec.kit.lang.utils.io.Files1;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResourceScanner {
    private final Set<URL> resources = new LinkedHashSet<URL>();
    private final Set<String> scannedResources = new LinkedHashSet<String>();
    private final Set<String> includeSuffix = new HashSet<String>();
    private final Set<String> excludeSuffix = new HashSet<String>();

    public static InputStream getResourceAsStream(String resource) {
        return ResourceScanner.class.getClassLoader().getResourceAsStream(resource);
    }

    public ResourceScanner addResource(URL ... resource) {
        if (Arrays1.isEmpty(resource)) {
            return this;
        }
        for (URL r : resource) {
            if (r == null) continue;
            this.resources.add(r);
        }
        return this;
    }

    public ResourceScanner with(Class<?> resourceClass) {
        Assert.notNull(resourceClass, "resourceClass is null", new Object[0]);
        URL r1 = resourceClass.getProtectionDomain().getCodeSource().getLocation();
        URL r2 = resourceClass.getClassLoader().getResource("");
        if (r1 != null) {
            this.resources.add(r1);
        }
        if (r2 != null) {
            this.resources.add(r2);
        }
        return this;
    }

    public ResourceScanner include(String ... suffix) {
        if (!Arrays1.isEmpty(suffix)) {
            Arrays1.forEach(this.includeSuffix::add, suffix);
        }
        return this;
    }

    public ResourceScanner exclude(String ... suffix) {
        if (!Arrays1.isEmpty(suffix)) {
            Arrays1.forEach(this.excludeSuffix::add, suffix);
        }
        return this;
    }

    public ResourceScanner scan() {
        for (URL resource : this.resources) {
            String protocol = resource.getProtocol();
            if ("file".equals(protocol)) {
                this.scanFile(resource);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            this.scanJar(resource);
        }
        return this;
    }

    private void scanFile(URL resource) {
        String path = Files1.getPath(Urls.decode(resource.getPath()));
        List<File> files = Files1.listFilesFilter(path, f -> !f.getName().endsWith(".class") && !f.isDirectory() && this.canAdd(f.getAbsolutePath()), true);
        this.scannedResources.addAll(Files1.toPaths(files));
    }

    private void scanJar(URL resource) {
        try {
            JarURLConnection connection = (JarURLConnection)resource.openConnection();
            if (connection == null) {
                return;
            }
            JarFile jarFile = connection.getJarFile();
            if (jarFile != null) {
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (jarEntryName.endsWith(".class") || jarEntryName.endsWith("/") || !this.canAdd(jarEntryName)) continue;
                    this.scannedResources.add(jarEntryName);
                }
            }
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime("scan jar file error", e);
        }
    }

    private boolean canAdd(String path) {
        boolean ie = this.includeSuffix.isEmpty();
        if (ie && this.excludeSuffix.isEmpty()) {
            return true;
        }
        if (!ie) {
            return this.includeSuffix.stream().anyMatch(path::endsWith);
        }
        return this.excludeSuffix.stream().noneMatch(path::endsWith);
    }

    public Set<URL> getResources() {
        return this.resources;
    }

    public Set<String> getScannedResources() {
        return this.scannedResources;
    }
}

