/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.collect.Maps;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;

public class Types {
    private Types() {
    }

    public static Class<?>[] getTypeParameterizedTypes(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
            int argumentsLength = arguments.length;
            Class[] classes = new Class[argumentsLength];
            for (int i = 0; i < argumentsLength; ++i) {
                Type argument = arguments[i];
                classes[i] = argument instanceof ParameterizedType ? (Class)((ParameterizedType)argument).getRawType() : (argument instanceof Class ? (Class)argument : Object.class);
            }
            return classes;
        }
        return null;
    }

    public static ParameterizedType toParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((genericSuper == null || Object.class.equals((Object)genericSuper)) && Arrays1.isNotEmpty(genericInterfaces = clazz.getGenericInterfaces())) {
                genericSuper = genericInterfaces[0];
            }
            return Types.toParameterizedType(genericSuper);
        }
        return null;
    }

    public static boolean isUnknown(Type type) {
        return type == null || type instanceof TypeVariable;
    }

    public static Class<?> getTypeRawClass(Type type) {
        if (type != null) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                return (Class)((TypeVariable)type).getBounds()[0];
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return Types.getTypeRawClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Type getTypeArgument(Type type) {
        return Types.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = Types.getTypeArguments(type);
        if (typeArguments != null && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        ParameterizedType pt = Types.toParameterizedType(type);
        if (pt == null) {
            return null;
        }
        return pt.getActualTypeArguments();
    }

    public static Type getActualType(Type actualType, Class<?> typeDefineClass, Type typeVariable) {
        Type[] types = Types.getActualTypes(actualType, typeDefineClass, typeVariable);
        if (Arrays1.isNotEmpty(types)) {
            return types[0];
        }
        return null;
    }

    public static Type[] getActualTypes(Type actualType, Class<?> typeDefineClass, Type ... typeVariables) {
        if (!typeDefineClass.isAssignableFrom(Types.getTypeRawClass(actualType))) {
            throw Exceptions.argument(Strings.format("parameter {} must be assignable from {}", typeDefineClass, actualType));
        }
        TypeVariable<Class<?>>[] typeVars = typeDefineClass.getTypeParameters();
        if (Arrays1.isEmpty(typeVars)) {
            return null;
        }
        Type[] actualTypeArguments = Types.getTypeArguments(actualType);
        if (Arrays1.isEmpty(actualTypeArguments)) {
            return null;
        }
        int size = Math.min(typeVars.length, actualTypeArguments.length);
        Map<TypeVariable<Class<?>>, Type> tableMap = Maps.of(typeVars, actualTypeArguments);
        Type[] result = new Type[size];
        for (int i = 0; i < typeVariables.length; ++i) {
            result[i] = typeVariables[i] instanceof TypeVariable ? tableMap.get(typeVariables[i]) : typeVariables[i];
        }
        return result;
    }
}

