/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.script;

import cn.orionsec.kit.lang.define.collect.ConcurrentReferenceHashMap;
import cn.orionsec.kit.lang.utils.Assert;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.reflect.Annotations;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import cn.orionsec.kit.lang.utils.script.Bind;
import cn.orionsec.kit.lang.utils.script.ScriptType;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class Scripts {
    private static final ScriptEngineManager MANAGER = new ScriptEngineManager();
    private static final ConcurrentReferenceHashMap<String, ScriptEngine> CACHE = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.SOFT);

    private Scripts() {
    }

    public static ScriptEngine createJavaScript() {
        return Scripts.createScript(ScriptType.JAVA_SCRIPT.getType());
    }

    public static ScriptEngine createLuaScript() {
        return Scripts.createScript(ScriptType.LUA.getType());
    }

    public static ScriptEngine createGroovyScript() {
        return Scripts.createScript(ScriptType.GROOVY.getType());
    }

    public static ScriptEngine createPythonScript() {
        return Scripts.createScript(ScriptType.PYTHON.getType());
    }

    public static ScriptEngine createScript(ScriptType type) {
        return Scripts.createScript(type.getType());
    }

    public static ScriptEngine createScript(String type) {
        ScriptEngine engine;
        if (ScriptType.PYTHON.getType().equals(type)) {
            System.setProperty("python.import.site", "false");
        }
        if ((engine = MANAGER.getEngineByName(type)) == null) {
            engine = MANAGER.getEngineByExtension(type);
        }
        if (engine == null) {
            engine = MANAGER.getEngineByMimeType(type);
        }
        if (engine == null) {
            throw Exceptions.unsupported("unsupported script type [" + type + "]");
        }
        return engine;
    }

    public static ScriptEngine getJavaScript() {
        return Scripts.getScript(ScriptType.JAVA_SCRIPT.getType());
    }

    public static ScriptEngine getLuaScript() {
        return Scripts.getScript(ScriptType.LUA.getType());
    }

    public static ScriptEngine getGroovyScript() {
        return Scripts.getScript(ScriptType.GROOVY.getType());
    }

    public static ScriptEngine getPythonScript() {
        return Scripts.getScript(ScriptType.PYTHON.getType());
    }

    public static ScriptEngine getScript(ScriptType type) {
        return Scripts.getScript(type.getType());
    }

    public static ScriptEngine getScript(String type) {
        return CACHE.computeIfAbsent(type, Scripts::createScript);
    }

    public static Object eval(String script) {
        return Scripts.eval(Scripts.createJavaScript(), script);
    }

    public static Object eval(String script, Bindings bindings) {
        return Scripts.eval(Scripts.createJavaScript(), script, bindings);
    }

    public static Object eval(String script, Map<String, Object> bindings) {
        return Scripts.eval(Scripts.createJavaScript(), script, bindings);
    }

    public static Object eval(String script, ScriptContext context) {
        return Scripts.eval(Scripts.createJavaScript(), script, context);
    }

    public static Object eval(ScriptEngine engine, String script) {
        try {
            return engine.eval(script);
        }
        catch (ScriptException e) {
            throw Exceptions.script(e);
        }
    }

    public static Object eval(ScriptEngine engine, String script, Map<String, Object> bindings) {
        try {
            return engine.eval(script, (Bindings)new SimpleBindings(bindings));
        }
        catch (ScriptException e) {
            throw Exceptions.script(e);
        }
    }

    public static Object eval(ScriptEngine engine, String script, Bindings bindings) {
        try {
            return engine.eval(script, bindings);
        }
        catch (ScriptException e) {
            throw Exceptions.script(e);
        }
    }

    public static Object eval(ScriptEngine engine, String script, ScriptContext context) {
        try {
            return engine.eval(script, context);
        }
        catch (ScriptException e) {
            throw Exceptions.script(e);
        }
    }

    public static <T> Object eval(String engine, String script, T args) {
        return Scripts.eval(Scripts.createScript(engine), script, args);
    }

    public static <T> Object eval(ScriptEngine engine, String script, T args) {
        Assert.notNull(args, "eval args is null", new Object[0]);
        try {
            Map<Method, Bind> methods = Annotations.getAnnotatedGetterMethodsMergeField(args.getClass(), Bind.class, true);
            LinkedHashMap<String, Object> binds = new LinkedHashMap<String, Object>();
            methods.forEach((m, a) -> binds.put(a.value(), Methods.invokeMethod(args, m)));
            return engine.eval(script, (Bindings)new SimpleBindings(binds));
        }
        catch (ScriptException e) {
            throw Exceptions.script(e);
        }
    }

    public static Invocable evalInvocable(ScriptEngine engine, String script) {
        Object eval = Scripts.eval(engine, script);
        return Assert.isInstanceOf(eval, Invocable.class, "script cannot invocable", new Object[0]);
    }

    public static Object invoke(ScriptEngine engine, String script, String func, Object ... args) {
        return Scripts.invoke(Scripts.evalInvocable(engine, script), func, args);
    }

    public static Object invoke(Invocable invocable, String func, Object ... args) {
        try {
            return invocable.invokeFunction(func, args);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw Exceptions.script(e);
        }
    }

    public static CompiledScript compile(String script) {
        return Scripts.compile(Scripts.createJavaScript(), script);
    }

    public static CompiledScript compile(ScriptEngine engine, String script) {
        try {
            Assert.isInstanceOf(engine, Compilable.class, "engine does not support compilable", new Object[0]);
            Compilable compEngine = (Compilable)((Object)engine);
            return compEngine.compile(script);
        }
        catch (ScriptException e) {
            throw Exceptions.script(e);
        }
    }
}

