/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.time;

import cn.orionsec.kit.lang.utils.Exceptions;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;

class BaseDates {
    public static final String WORLD = "EEE MMM dd HH:mm:ss z yyyy";
    public static final String YM = "yyyy-MM";
    public static final String MD = "MM-dd";
    public static final String MD_HM = "MM-dd HH:mm";
    public static final String MD_HMS = "MM-dd HH:mm:ss";
    public static final String YMD = "yyyy-MM-dd";
    public static final String YMD_HM = "yyyy-MM-dd HH:mm";
    public static final String YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD_HMSS = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String HMS = "HH:mm:ss";
    public static final String HMSS = "HH:mm:ss SSS";
    public static final String YM1 = "yyyy/MM";
    public static final String YMD1 = "yyyy/MM/dd";
    public static final String YMD_HM1 = "yyyy/MM/dd HH/mm";
    public static final String YMD_HMS1 = "yyyy/MM/dd HH/mm/ss";
    public static final String YMD_HMSS1 = "yyyy/MM/dd HH/mm/ss SSS";
    public static final String YM2 = "yyyyMM";
    public static final String YMD2 = "yyyyMMdd";
    public static final String YMD_HM2 = "yyyyMMddHHmm";
    public static final String YMD_HMS2 = "yyyyMMddHHmmss";
    public static final String YMD_HMSS2 = "yyyyMMddHHmmssSSS";
    public static final String YMD_T_HMS_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String[] PARSE_PATTERN_GROUP1 = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss SSS"};
    public static final String[] PARSE_PATTERN_GROUP2 = new String[]{"yyyy/MM/dd HH/mm/ss", "yyyy/MM/dd", "yyyy/MM", "yyyy/MM/dd HH/mm", "yyyy/MM/dd HH/mm/ss SSS"};
    public static final String[] PARSE_PATTERN_GROUP3 = new String[]{"yyyyMMddHHmmss", "yyyyMMdd", "yyyyMM", "yyyyMMddHHmm", "yyyyMMddHHmmssSSS"};
    public static final long WEEK_STAMP = 604800000L;
    public static final long YEAR_STAMP = 31536000000L;
    public static final long MONTH_STAMP = 2592000000L;
    public static final long DAY_STAMP = 86400000L;
    public static final long HOUR_STAMP = 3600000L;
    public static final long MINUTE_STAMP = 60000L;
    public static final long SECOND_STAMP = 1000L;
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    public static final ZoneOffset DEFAULT_ZONE_OFFSET = ZoneOffset.of("+8");
    public static final ZoneOffset DEFAULT_ZERO_ZONE_OFFSET = ZoneOffset.ofHours(0);
    private static final String PAD_HMS = "%04d-%02d-%02d";
    private static final String PAD_YMD_HMS = "%04d-%02d-%02d %02d:%02d:%02d";
    private static final String PAD_YMD_HMSS = "%04d-%02d-%02d %02d:%02d:%02d %03d";

    BaseDates() {
    }

    public static boolean isDateClass(Class<?> c) {
        return c == Long.TYPE || c == Long.class || c == Integer.TYPE || c == Integer.class || c == Date.class || c == Calendar.class || c == LocalDate.class || c == LocalDateTime.class || c == Instant.class;
    }

    public static boolean isMilli(long l) {
        return l > 1000000000000L;
    }

    public static long getSecondTime(long timestamp) {
        return timestamp / 1000L;
    }

    public static String hourType(int hour) {
        if (hour >= 0 && hour < 6) {
            return "\u51cc\u6668";
        }
        if (hour >= 6 && hour < 11) {
            return "\u4e0a\u5348";
        }
        if (hour >= 11 && hour < 13) {
            return "\u4e2d\u5348";
        }
        if (hour >= 13 && hour < 18) {
            return "\u4e0b\u5348";
        }
        if (hour >= 18 && hour < 20) {
            return "\u508d\u665a";
        }
        if (hour >= 20 && hour < 22) {
            return "\u665a\u4e0a";
        }
        if (hour >= 22 && hour <= 23) {
            return "\u6df1\u591c";
        }
        return "\u672a\u77e5";
    }

    public static boolean isExpired(long time) {
        return time < System.currentTimeMillis();
    }

    public static boolean inFuture(long time) {
        return time > System.currentTimeMillis();
    }

    public static String interval(long ms) {
        return BaseDates.interval(ms, false, null, null, null, null);
    }

    public static String interval(long ms, boolean full) {
        return BaseDates.interval(ms, full, null, null, null, null);
    }

    public static String interval(long ms, boolean full, String day, String hour, String minute, String second) {
        long[] analysis = BaseDates.intervalAnalysis(ms);
        if (full) {
            return analysis[0] + (day == null ? "\u5929" : day) + analysis[1] + (hour == null ? "\u65f6" : hour) + analysis[2] + (minute == null ? "\u5206" : minute) + analysis[3] + (second == null ? "\u79d2" : second);
        }
        boolean ay = true;
        boolean ah = true;
        boolean am = true;
        if (analysis[0] == 0L) {
            ay = false;
        }
        if (!ay && analysis[1] == 0L) {
            ah = false;
        }
        if (!ah && analysis[2] == 0L) {
            am = false;
        }
        StringBuilder sb = new StringBuilder();
        if (ay) {
            sb.append(analysis[0]).append(day == null ? "\u5929" : day);
        }
        if (ah) {
            sb.append(analysis[1]).append(hour == null ? "\u65f6" : hour);
        }
        if (am) {
            sb.append(analysis[2]).append(minute == null ? "\u5206" : minute);
        }
        sb.append(analysis[3]).append(second == null ? "\u79d2" : second);
        return sb.toString();
    }

    public static long[] intervalAnalysis(long ms) {
        long distanceDay = ms / 86400000L;
        long distanceHour = ms % 86400000L / 3600000L;
        long distanceMinute = ms % 86400000L % 3600000L / 60000L;
        long distanceSecond = ms % 86400000L % 3600000L % 60000L / 1000L;
        if (distanceSecond == 0L && ms != 0L) {
            distanceSecond = 1L;
        }
        return new long[]{distanceDay, distanceHour, distanceMinute, distanceSecond};
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int getMonthLastDay(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 2: {
                return BaseDates.isLeapYear(year) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        throw Exceptions.argument("month must >= 1 and <= 12");
    }

    public static int getQuarter(int month) {
        switch (month) {
            case 1: 
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 7: 
            case 8: 
            case 9: {
                return 3;
            }
            case 10: 
            case 11: 
            case 12: {
                return 4;
            }
        }
        throw Exceptions.argument("month must >= 1 and <= 12");
    }

    public static String pad(int year, int month, int day) {
        return String.format(PAD_HMS, year, month, day);
    }

    public static String pad(int year, int month, int day, int hour, int minute, int second) {
        return String.format(PAD_YMD_HMS, year, month, day, hour, minute, second);
    }

    public static String pad(int year, int month, int day, int hour, int minute, int second, int milli) {
        return String.format(PAD_YMD_HMSS, year, month, day, hour, minute, second, milli);
    }
}

